% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{initial_cache}
\alias{initial_cache}
\alias{get_cache}
\alias{rm_cache}
\alias{initial_cache_item}
\alias{get_cache_item}
\alias{rm_cache_item}
\alias{update_cache_item}
\alias{get_cache_element}
\alias{prune_cache_item}
\alias{cache_list_items}
\alias{cache_size}
\alias{cache_save}
\alias{cache_load}
\alias{with_cache}
\title{Cache intermediate data}
\usage{
initial_cache()

get_cache()

rm_cache()

initial_cache_item(item)

get_cache_item(item)

rm_cache_item(item)

update_cache_item(item, elements, ttl = NULL)

get_cache_element(item, elements, default = NULL, prune_expired = TRUE)

prune_cache_item(item)

cache_list_items()

cache_size()

cache_save(path)

cache_load(path)

with_cache(item, key, compute, ttl = NULL)
}
\arguments{
\item{item}{Cache item name}

\item{elements}{Elements to cache}

\item{ttl}{Time-to-live in seconds}

\item{default}{Default value if cache element is missing}

\item{prune_expired}{Logical, whether to prune expired items}

\item{path}{File path to save or load cache}

\item{key}{Element key}

\item{compute}{Function to compute value when missing}
}
\value{
Cache environment, item, or selected elements
}
\description{
Utilities to cache intermediate data: initialize items, update items,
remove items, and retrieve elements.
}
\examples{
\dontrun{
 slow_fib <- function(x) {
     if (x < 2) return(1)
     slow_fib(x-2) + slow_fib(x-1)
 }
 
 fast_fib <- function(x) {
     if (x < 2) return(1)
     res <- get_cache_element('fibonacci', as.character(x))
     if (!is.null(res)) {
         return(res)
     }
     res <- fast_fib(x-2) + fast_fib(x-1)
     e <- list()
     e[[as.character(x)]] <- res
     update_cache_item('fibonacci', e)
     return(res)
 }

 system.time(slow_fib(30))
 system.time(fast_fib(30)) 
    
 }
}
\concept{cache-utils}
