% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse8601.R
\name{.parseISO8601}
\alias{.parseISO8601}
\alias{ISO8601}
\alias{parseISO8601}
\title{Internal ISO 8601:2004(e) Time Parser}
\usage{
.parseISO8601(x, start, end, tz = "")
}
\arguments{
\item{x}{A character string conforming to the ISO 8601:2004(e) rules.}

\item{start}{Lower constraint on range.}

\item{end}{Upper constraint of range}

\item{tz}{Timezone (tzone) to use internally.}
}
\value{
A two element list with an entry named \sQuote{first.time} and
one named \sQuote{last.time}.
}
\description{
This function replicates most of the ISO standard for parsing times and
time-based ranges in a universally accepted way. The best documentation is
the official ISO page as well as the Wikipedia entry for ISO 8601:2004.
}
\details{
The basic idea is to create the endpoints of a range, given a string
representation. These endpoints are aligned in POSIXct time to the zero
second of the day at the beginning, and the 59.9999th second of the 59th
minute of the 23rd hour of the final day.

For dates prior to the epoch (1970-01-01) the ending time is aligned to the
59.0000 second. This is due to a bug/feature in the \R implementation of
\code{as.POSIXct()} and \code{mktime0()} at the C-source level. This limits the
precision of ranges prior to 1970 to 1 minute granularity with the current
\pkg{xts} workaround.

Recurring times over multiple days may be specified using the "T" notation.
See the examples for details.
}
\note{
There is no checking done to test for a properly constructed ISO
format string. This must be correctly entered by the user.

When using durations, it is important to note that the time of the duration
specified is not necessarily the same as the realized periods that may be
returned when applied to an irregular time series. This is not a bug, it is
a standards and implementation gotcha.
}
\examples{

# the start and end of 2000
.parseISO8601('2000')

# the start of 2000 and end of 2001
.parseISO8601('2000/2001')

# May 1, 2000 to Dec 31, 2001
.parseISO8601('2000-05/2001')

# May 1, 2000 to end of Feb 2001
.parseISO8601('2000-05/2001-02')

# Jan 1, 2000 to Feb 29, 2000; note the truncated time on the LHS
.parseISO8601('2000-01/02')

# 8:30 to 15:00 (used in xts subsetting to extract recurring times)
.parseISO8601('T08:30/T15:00')

}
\references{
\url{https://en.wikipedia.org/wiki/ISO_8601}\cr
\url{https://www.iso.org/iso-8601-date-and-time-format.html}
}
\author{
Jeffrey A. Ryan
}
\keyword{utilities}
