% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xset_plots.R
\name{dv_vs_ipred_modavg}
\alias{dv_vs_ipred_modavg}
\alias{dv_vs_pred_modavg}
\alias{ipred_vs_idv_modavg}
\alias{pred_vs_idv_modavg}
\alias{plotfun_modavg}
\title{Model average plots}
\usage{
dv_vs_ipred_modavg(
  xpdb_s,
  ...,
  .lineage = FALSE,
  algorithm = c("maa", "msa"),
  weight_type = c("individual", "population"),
  auto_backfill = FALSE,
  weight_basis = c("ofv", "aic", "res"),
  res_col = "RES",
  quiet
)

dv_vs_pred_modavg(
  xpdb_s,
  ...,
  .lineage = FALSE,
  algorithm = c("maa", "msa"),
  weight_type = c("individual", "population"),
  auto_backfill = FALSE,
  weight_basis = c("ofv", "aic", "res"),
  res_col = "RES",
  quiet
)

ipred_vs_idv_modavg(
  xpdb_s,
  ...,
  .lineage = FALSE,
  algorithm = c("maa", "msa"),
  weight_type = c("individual", "population"),
  auto_backfill = FALSE,
  weight_basis = c("ofv", "aic", "res"),
  res_col = "RES",
  quiet
)

pred_vs_idv_modavg(
  xpdb_s,
  ...,
  .lineage = FALSE,
  algorithm = c("maa", "msa"),
  weight_type = c("individual", "population"),
  auto_backfill = FALSE,
  weight_basis = c("ofv", "aic", "res"),
  res_col = "RES",
  quiet
)

plotfun_modavg(
  xpdb_s,
  ...,
  .lineage = FALSE,
  avg_cols = NULL,
  avg_by_type = NULL,
  algorithm = c("maa", "msa"),
  weight_type = c("individual", "population"),
  auto_backfill = FALSE,
  weight_basis = c("ofv", "aic", "res"),
  res_col = "RES",
  .fun = NULL,
  .funargs = list(),
  quiet
)
}
\arguments{
\item{xpdb_s}{<\code{xpose_set}> object}

\item{...}{<\code{tidyselect}> of models in set. If empty, all models are
used in order of their position in the set. May also use a formula,
which will just be processed with \code{all.vars()}.}

\item{.lineage}{<\code{logical}> where if \code{TRUE}, \code{...} is processed}

\item{algorithm}{<\code{character}> Model selection or model averaging}

\item{weight_type}{<\code{character}> Individual-level averaging or by full dataset.}

\item{auto_backfill}{<\code{logical}> If true, <\code{\link{backfill_iofv}}> is automatically
applied.}

\item{weight_basis}{<\code{character}> Weigh by OFV (default), AIC or residual.}

\item{res_col}{<\code{character}> Column to weight by if \code{"res"} weight basis.}

\item{quiet}{<\code{logical}> Minimize extra output.}

\item{avg_cols}{<\code{tidyselect}> columns in data to average}

\item{avg_by_type}{<\code{character}> Mainly for use in wrapper functions.
Column type to average, but resulting column names must be valid
for \code{avg_cols} (ie, same across all objects in the set). \code{avg_cols} will
be overwritten.}

\item{.fun}{<\code{function}> For slightly more convenient
piping of model-averaged \code{xpose_data} into a plotting
function.}

\item{.funargs}{<\code{list}> Extra args to pass to function.
If passing \code{tidyselect} arguments, be mindful of where
quosures might be needed. See Examples.}
}
\value{
The desired plot
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This is for use when the model averaging of a set
is planned.
}
\examples{
\donttest{

pheno_set \%>\%
  dv_vs_ipred_modavg(run8,run9,run10, auto_backfill = TRUE)

pheno_set \%>\%
  dv_vs_pred_modavg(run8,run9,run10, auto_backfill = TRUE)

pheno_set \%>\%
  ipred_vs_idv_modavg(run8,run9,run10, auto_backfill = TRUE)

pheno_set \%>\%
  pred_vs_idv_modavg(run8,run9,run10, auto_backfill = TRUE)

# Model averaged ETA covariates
pheno_set \%>\%
  plotfun_modavg(run8,run9,run10, auto_backfill = TRUE,
     avg_by_type = "eta",.fun = eta_vs_catcov,
     # Note quoting
     .funargs = list(etavar=quote(ETA1)))

}
}
\seealso{
\code{\link[=modavg_xpdb]{modavg_xpdb()}}
}
