% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diag_constants.R
\name{diagnose_constants}
\alias{diagnose_constants}
\title{Check for potential parameterization issues}
\usage{
diagnose_constants(
  xpdb,
  df = NULL,
  micro_pattern = "^K(\\\\d+|EL?)$",
  vol_pattern = "^V(C|D|1|2|)$",
  fo_abs = "KA",
  fo_rates = c("alpha_beta", "lambda", "custom"),
  checks = list(flip_flop = NULL, neg_microvol = NULL, units_match = NULL),
  df_units = NULL,
  .problem,
  quiet = xpdb$options$quiet
)
}
\arguments{
\item{xpdb}{<\code{xpose_data}> object}

\item{df}{Optional <\code{data.frame}> of parameter values.}

\item{micro_pattern}{Regex. Pattern for microconstants}

\item{vol_pattern}{Regex. Pattern for volume parameter (should only match 1)}

\item{fo_abs}{First-order absorption parameter (singular, fixed, not regex).}

\item{fo_rates}{Derived ("macro") exponential rate constants (fixed). See Details}

\item{checks}{See Details}

\item{df_units}{Named list of units. If \code{NULL}, either ignore (\code{df}) or pull
from \code{xpdb} object.}

\item{.problem}{Used in fetching parameters.}

\item{quiet}{Should parameter fetching produce output?}
}
\value{
Nothing
}
\description{
This function can help diagnose potential flip-flop or other
issues related to the parameterization of the model.
}
\details{
The function prints output directly, not as an object.

A finding from these checks does not necessarily prove
the parameterization is erroneous (indeed, flip-flop PK can exist),
but coupled with other findings would help in diagnosing issues.

For \code{fo_rates}, \code{"alpha_beta"} and \code{"lambda"} are convenience placeholders
meaning literally \code{c("ALPHA","BETA","GAMMA")} and \code{paste0("LAMBA",1:3)},
respectively. If capitalization or competing names will be an issue, specify
a custom set of names (provide a character vector of names, do not pass
\code{"custom"} to the argument). If only a subset of \code{alpha_beta} or \code{lambda}
are available, but these are the parameterizations used (eg, only \code{ALPHA})
these options can still be used. If \code{LAMBDA} is used alone, it will not
match the \code{"lambda"} default. If naming conventions are incompatible, it
is suggested \code{xpdb} or \code{df} be subject to mutation or renaming to use this
function.

The available checks at this time are:
\itemize{
\item \code{flip_flop} Checks if \code{fo_abs} are slower than the derived \code{fo_rates}.
\item \code{neg_microvol} Checks if any microconstant or volume is negative. Note
this check applies to parameterization of microconstants, so only a single volume
(parameterizations with multiple volumes do not use microconstants) should match
\code{vol_pattern}.
\item \code{units_match} For any checks, verifies units are consistent. This
check requires units are defined by \code{\link[xpose:set_vars]{set_var_units()}}
or \code{df_units} for parameters applicable to a requested check.
}
Checks must be requested as a named list of these elements, either \code{TRUE} or
\code{FALSE} (truth determines if the test is done). If the default \code{NULL} is used,
test will be run if the required parameters are present.
}
\examples{

if (!rlang::is_installed("rxode2") ||
   !exists("rxDerived", envir = rlang::ns_env("rxode2"))) {
nlmixr2_m3 \%>\%
  backfill_derived() \%>\%
  diagnose_constants(vol_pattern = "^V$")

nlmixr2_m3 \%>\%
  backfill_derived() \%>\%
  diagnose_constants(
    vol_pattern = "^V$",
    df_units = list(KA = "1/hr", ALPHA = "1/hr"),
    checks = list(neg_microvol = FALSE)
  )

# Using df form
derive_prm(nlmixr2_m3) \%>\%
  diagnose_constants(df = ., vol_pattern = "^V$")

}
}
\seealso{
\code{\link[=backfill_derived]{backfill_derived()}}
}
