% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_prd3d.R
\name{show_prd3d}
\alias{show_prd3d}
\title{Plot a 3-d surface of predictions}
\usage{
show_prd3d(mod, ylab)
}
\arguments{
\item{mod}{input model object as returned by \code{\link{anlz_gam}}}

\item{ylab}{chr string for y-axis label}
}
\value{
a \code{plotly} surface
}
\description{
Plot a 3-d surface of predictions
}
\examples{
library(dplyr)

# data to model
tomod <- rawdat \%>\%
  filter(station \%in\% 34) \%>\%
  filter(param \%in\% 'chl') \%>\% 
  filter(yr > 2015)
  
mod <- anlz_gam(tomod, trans = 'log10')

show_prd3d(mod, ylab = 'Chlorophyll-a (ug/L)')
}
\concept{show}
