% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ic_tail.R
\name{ic_tail}
\alias{ic_tail}
\title{Credibility interval limits for the information component}
\usage{
ic_tail(n_obs, n_exp, p = 0.025)
}
\arguments{
\item{n_obs}{Number of observed cases}

\item{n_exp}{Number of expected cases (see Details)}

\item{p}{End of chosen credibility interval}
}
\value{
A numeric vector. The lower end of the credibility interval
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} Compute
the Information Component credibility interval, typically the lower end of
the 95\% CI, also known as the IC025.
}
\details{
The ends of the credibility interval of the information component
are estimated with the gamma distribution.
\code{n_exp} is defined as \code{n_drug * n_event / n_total} for the basic IC
(formula is different for interactions)
Do not add \code{+.5} to \code{n_obs} and \code{n_exp} as it is automatically done in the function.
By default, IC025 is computed. Change \code{p} for different ends.
It may be easier to use \code{\link[=compute_dispro]{compute_dispro()}}, which internally calls this function.
}
\examples{

ic_tail(n_obs = 12,
        n_exp = 5)

}
\seealso{
\code{\link[=compute_dispro]{compute_dispro()}}
}
\keyword{disproportionality}
\keyword{ic}
