#
# renv 1.1.5.9000 [rstudio/renv#4c63ee7]: A dependency management toolkit for R.
# Generated using `renv:::vendor()` at 2025-12-12 13:03:25.497218.
#

renv <- new.env(parent = new.env())

renv$initialize <- function(libname, pkgname) {
  # set up renv + imports environments
  attr(renv, "name") <- "embedded:renv"
  attr(parent.env(renv), "name") <- "imports:renv"

  # get imports
  imports <- list(
    tools = c(
      "file_ext",
      "md5sum",
      "package_dependencies",
      "pskill",
      "psnice",
      "write_PACKAGES"
    ),
    utils = c(
      "Rprof",
      "URLencode",
      "adist",
      "available.packages",
      "browseURL",
      "citation",
      "contrib.url",
      "download.file",
      "download.packages",
      "file.edit",
      "getCRANmirrors",
      "head",
      "help",
      "install.packages",
      "installed.packages",
      "modifyList",
      "old.packages",
      "packageDescription",
      "packageVersion",
      "read.table",
      "remove.packages",
      "sessionInfo",
      "str",
      "summaryRprof",
      "tail",
      "tar",
      "toBibtex",
      "untar",
      "unzip",
      "update.packages",
      "zip"
    )
  )

  # load the imports required by renv
  for (package in names(imports)) {
    namespace <- asNamespace(package)
    functions <- imports[[package]]
    list2env(mget(functions, envir = namespace), envir = parent.env(renv))
  }

  # source renv into the aforementioned environment
  script <- system.file("vendor/renv.R", package = .packageName)
  sys.source(script, envir = renv)

  # initialize metadata
  renv$the$metadata <- list(
    embedded = TRUE,
    version = structure(
      "1.1.5.9000",
      sha = "4c63ee794a768911ea470950dafd20368c862155"
    )
  )

  # run our load / attach hooks so internal state is initialized
  renv$.onLoad(libname, pkgname)

  # remove our initialize method when we're done
  rm(list = "initialize", envir = renv)
}
