% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genericrules.R
\name{field_length}
\alias{field_length}
\title{Check number of code points}
\usage{
field_length(x, n = NULL, min = NULL, max = NULL, ...)
}
\arguments{
\item{x}{Bare (unquoted) name of a variable. 
Otherwise a vector of class \code{character}. Coerced to character as 
necessary.}

\item{n}{Number of code points required.}

\item{min}{Mimimum number of code points}

\item{max}{Maximum number of code points}

\item{...}{passed to \code{nchar} (for example \code{type="width"})}
}
\value{
A \code{[logical]} of size \code{length(x)}.
}
\description{
A convenience function testing for field length.
}
\section{Details}{


The number of code points (string length) may depend on current locale
settings or encoding issues, including those caused by inconsistent choices
of \code{UTF} normalization.
}

\examples{

df <- data.frame(id = 11001:11003, year = c("2018","2019","2020"), value = 1:3)
rule <- validator(field_length(year, 4), field_length(id, 5))
out <- confront(df, rule) 
as.data.frame(out)

}
\seealso{
Other format-checkers: 
\code{\link{field_format}()},
\code{\link{number_format}()}
}
\concept{format-checkers}
