% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.uniReg.R
\name{print.cv.uniReg}
\alias{print.cv.uniReg}
\title{print a cross-validated uniReg object}
\usage{
\method{print}{cv.uniReg}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{x}{fitted 'cv.uniReg' object}

\item{digits}{significant digits in printout}

\item{\dots}{additional print arguments}
}
\value{
A summary is printed, and nothing is returned.
}
\description{
Print a summary of the results of cross-validation for a uniReg model.
}
\details{
A summary of the cross-validated uniReg fit is produced. This is an augmented summary of a cv.glmnet object, with an extra row corresponding to the smallest lambda in the path
}
\examples{

x = matrix(rnorm(100 * 20), 100, 20)
y = rnorm(100)
fit1 = cv.uniReg(x, y)
print(fit1)
}
\author{
Trevor Hastie and Rob Tibshirani\cr Maintainer:
Trevor Hastie \href{mailto:hastie@stanford.edu}{hastie@stanford.edu}
}
