% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{masses}
\alias{masses}
\title{Masses: Elements and isotopes}
\format{
A data.table having 288 rows and 23 variables:
\describe{
\item{element}{Element symbol in lower case}
\item{symbol}{Element symbol in upper case}
\item{isotope}{Isotope symbol in lower case}
\item{label}{Isotope symbol in upper case}
\item{nm}{Nominal mass of the isotope}
\item{exact_mass}{Exact mass of the isotope}
\item{mole_fraction}{Mole fraction compared to all isotopes of an element}
\item{relative_abundance}{Relative abundance compared to the main (most abundant) isotope}
\item{valence}{Valence at standard conditions}
\item{valence2}{Alternative valence at standard conditions}
\item{hill_order}{Rank in Hill Order for molecular formulas (cf. https://en.wikipedia.org/wiki/Chemical_formula)}
}
}
\source{
{https://www.nist.gov/pml/atomic-weights-and-isotopic-compositions-relative-atomic-masses}
}
\usage{
masses
}
\description{
Contains masses, valences, isotopes and isotope ratios of elements
based on data by NIST Physical Measurement Laboratory (https://www.nist.gov/pml).
}
\examples{
data(masses)
}
\seealso{
Other ume data: 
\code{\link{known_mf}},
\code{\link{lib_demo}},
\code{\link{mf_data_demo}},
\code{\link{nice_labels_dt}},
\code{\link{peaklist_demo}},
\code{\link{tab_ume_labels}}
}
\concept{ume data}
\keyword{datasets}
