% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tspredbench.R
\docType{data}
\name{pesticides}
\alias{pesticides}
\title{Pesticides Use Statistics}
\format{
A list of time series.
}
\source{
\href{https://www.fao.org/faostat/en/#data/RP}{Pesticides Use Database}
}
\usage{
data(pesticides)
}
\description{
Statistics on the use of major pesticide groups and relevant chemical families.
Data Type: pesticides use. Category:	Environments. Creation Date	2024.
}
\details{
Series are named by country with \verb{_pesticides} suffix; values are annual usage amounts.
}
\examples{
# Load pesticides list and plot one series
data(pesticides)
# pesticides <- loadfulldata(pesticides)
series <- pesticides[[1]]
ts.plot(series, ylab = "tonnes", xlab = "Year", main = "Pesticides example")
}
\references{
FAO. 2024. FAOSTAT: Pesticides Use. RP_e_README_Domain_Information_2024.
\href{https://www.fao.org/faostat/en/#data/RP}{FAOSTAT Pesticides Use Database}
}
\keyword{datasets}
