% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tseffects.R
\name{GDRF.adl.plot}
\alias{GDRF.adl.plot}
\title{Evaluate (and possibly plot) the General Dynamic Response Function (GDRF) for an autoregressive distributed lag (ADL) model}
\usage{
GDRF.adl.plot(
  model = NULL,
  x.vrbl = NULL,
  y.vrbl = NULL,
  d.x = NULL,
  d.y = NULL,
  shock.history = "pulse",
  inferences.y = "levels",
  inferences.x = "levels",
  dM.level = 0.95,
  s.limit = 20,
  se.type = "const",
  return.data = FALSE,
  return.plot = TRUE,
  return.formulae = FALSE,
  ...
)
}
\arguments{
\item{model}{the \code{lm} model containing the ADL estimates}

\item{x.vrbl}{named vector of the x variables and corresponding lag orders in the ADL model}

\item{y.vrbl}{named vector of the (lagged) y variables and corresponding lag orders in the ADL model}

\item{d.x}{the order of differencing of the x variable in the ADL model}

\item{d.y}{the order of differencing of the y variable in the ADL model}

\item{shock.history}{the desired shock history. \code{shock.history} determines the shock history (h) that will be applied to the independent variable. -1 represents a pulse. 0 represents a step. These can also be specified via \code{pulse} and \code{step}. For others, see Vande Kamp, Jordan, and Rajan. The default is \code{pulse}}

\item{inferences.y}{does the user want resulting inferences about the dependent variable in levels or in differences? (For y variables where \code{d.y} is 0, this is automatically levels.) The default is \code{levels}}

\item{inferences.x}{does the user want to apply the shock history to the independent variable in levels or in differences? (For x variables where \code{d.x} is 0, this is automatically levels.) The default is \code{levels}}

\item{dM.level}{significance level of the GDRF, calculated by the delta method. The default is 0.95}

\item{s.limit}{an integer for the number of periods to determine the GDRF (beginning at s = 0)}

\item{se.type}{the type of standard error to extract from the model. The default is \code{const}, but any argument to \code{vcovHC} from the \code{sandwich} package is accepted}

\item{return.data}{return the raw calculated GDRFs as a list element under \code{estimates}. The default is \code{FALSE}}

\item{return.plot}{return the visualized GDRFs as a list element under \code{plot}. The default is \code{TRUE}}

\item{return.formulae}{return the formulae for the GDRFs as a list element under \code{formulae} (for the GDRFs) and \code{binomials} (for the shock history). The default is \code{FALSE}}

\item{...}{other arguments to be passed to the call to plot}
}
\description{
Evaluate (and possibly plot) the General Dynamic Response Function (GDRF) for an autoregressive distributed lag (ADL) model
}
\examples{

# ADL(1,1)
# Use the toy data to run an ADL. No argument is made this is well specified; it is just expository 
model.toydata <- lm(y ~ l_1_y + x + l_1_x, data = toy.ts.interaction.data)

# Pulse effect of x
GDRF.adl.plot(model = model.toydata, 
				x.vrbl = c("x" = 0, "l_1_x" = 1), 
				y.vrbl = c("l_1_y" = 1),
				d.x = 0,
				d.y = 0,
				shock.history = "pulse", 
				inferences.y = "levels",
				inferences.x = "levels",
				s.limit = 20)

# Step effect of x. You can store the data to draw your own plot,
#  if you prefer
test.cumulative <- GDRF.adl.plot(model = model.toydata, 
				x.vrbl = c("x" = 0, "l_1_x" = 1), 
				y.vrbl = c("l_1_y" = 1),
				d.x = 0,
				d.y = 0,
				shock.history = "step", 
				inferences.y = "levels",
				inferences.x = "levels",
				s.limit = 20)
test.cumulative$plot

}
\author{
Soren Jordan, Garrett N. Vande Kamp, and Reshikesav Rajan
}
\keyword{ADL}
\keyword{GDRF}
\keyword{plot}
