% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/wrapers.R
\name{torch_vander}
\alias{torch_vander}
\title{Vander}
\usage{
torch_vander(x, N = NULL, increasing = FALSE)
}
\arguments{
\item{x}{(Tensor) 1-D input tensor.}

\item{N}{(int, optional) Number of columns in the output. If N is not specified,
a square array is returned \eqn{(N = len(x))}.}

\item{increasing}{(bool, optional) Order of the powers of the columns. If TRUE,
the powers increase from left to right, if FALSE (the default) they are reversed.}
}
\description{
Vander
}
\section{vander(x, N=None, increasing=FALSE) -> Tensor }{


Generates a Vandermonde matrix.

The columns of the output matrix are elementwise powers of the input vector
\eqn{x^{(N-1)}, x^{(N-2)}, ..., x^0}.
If increasing is TRUE, the order of the columns is reversed
\eqn{x^0, x^1, ..., x^{(N-1)}}. Such a
matrix with a geometric progression in each row is
named for Alexandre-Theophile Vandermonde.
}

\examples{
if (torch_is_installed()) {

x <- torch_tensor(c(1, 2, 3, 5))
torch_vander(x)
torch_vander(x, N=3)
torch_vander(x, N=3, increasing=TRUE)
}
}
