% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tissot.R
\name{indicatrix}
\alias{indicatrix}
\title{Compute Tissot indicatrix ellipse geometry}
\usage{
indicatrix(x, target = NULL, ..., source = "EPSG:4326")
}
\arguments{
\item{x}{a \code{tissot_tbl}, or any xy-ish input (see \code{\link[=tissot]{tissot()}})}

\item{target}{target projection CRS (extracted from \code{tissot_tbl}
attributes if \code{x} is one; required otherwise)}

\item{...}{passed to \code{\link[=tissot]{tissot()}}}

\item{source}{source CRS (default \code{"EPSG:4326"})}
}
\value{
An \code{indicatrix_list} object (a list of \code{indicatrix} objects with
\code{source} and \code{target} stored as attributes)
}
\description{
Generates indicatrix objects for plotting at each point.
Returns an \code{indicatrix_list} containing individual indicatrix objects.
}
\details{
\code{indicatrix()} accepts either:
\itemize{
\item A \code{tissot_tbl} object (from \code{\link[=tissot]{tissot()}}) — projection is extracted
from attributes, \code{target} is optional
\item Any xy-ish input with an explicit \code{target}
}
}
\examples{
## From a tissot_tbl
r <- tissot(cbind(seq(-150, 150, by = 30), 0), "+proj=robin")
ii <- indicatrix(r)
plot(ii, scale = 5e5)

## From raw coordinates
ii2 <- indicatrix(c(0, 45), "+proj=stere +lat_0=90")
plot(ii2)
}
\seealso{
\code{\link[=tissot]{tissot()}}, \code{\link[=plot.indicatrix]{plot.indicatrix()}}, \code{\link[=plot.indicatrix_list]{plot.indicatrix_list()}},
\code{\link[=ti_ellipse]{ti_ellipse()}}
}
