% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_connect_to_cache.R
\name{tw_connect_to_cache}
\alias{tw_connect_to_cache}
\title{Return a connection to be used for caching}
\usage{
tw_connect_to_cache(
  connection = NULL,
  RSQLite = NULL,
  language = tidywikidatar::tw_get_language(),
  cache = NULL
)
}
\arguments{
\item{connection}{Defaults to \code{NULL}. If \code{NULL}, uses local SQLite database.
If given, must be a connection object or a list with relevant connection
settings (see example).}

\item{RSQLite}{Defaults to \code{NULL}, expected either \code{NULL} or logical. If set
to \code{FALSE}, details on the database connection must be given either as a
named list in the connection parameter, or with \code{\link[=tw_set_cache_db]{tw_set_cache_db()}} as
environment variables.}

\item{language}{Defaults to language set with \code{\link[=tw_set_language]{tw_set_language()}}; if not
set, "en". Use "all_available" to keep all languages. For available
language values, see
\href{https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}{the
dedicated Wikimedia page}.}

\item{cache}{Defaults to \code{NULL}. If given, it should be given either \code{TRUE}
or \code{FALSE}. Typically set with \code{\link[=tw_enable_cache]{tw_enable_cache()}} or \code{\link[=tw_disable_cache]{tw_disable_cache()}}.}
}
\value{
A connection object.
}
\description{
Return a connection to be used for caching
}
\examples{
\donttest{
if (interactive()) {
  cache_connection <- pool::dbPool(
    RSQLite::SQLite(), # or e.g. odbc::odbc(),
    Driver = ":memory:", # or e.g. "MariaDB",
    Host = "localhost",
    database = "example_db",
    UID = "example_user",
    PWD = "example_pwd"
  )
  tw_connect_to_cache(cache_connection)


  db_settings <- list(
    driver = "MySQL",
    host = "localhost",
    server = "localhost",
    port = 3306,
    database = "tidywikidatar",
    user = "secret_username",
    pwd = "secret_password"
  )

  tw_connect_to_cache(db_settings)
}
}

}
