# Extracted from test-row.R:93

# setup ------------------------------------------------------------------------
library(testthat)
test_env <- simulate_test_env(package = "tidyna", path = "..")
attach(test_env, warn.conflicts = FALSE)

# prequel ----------------------------------------------------------------------
mat_clean <- matrix(1:6, nrow = 2, byrow = TRUE)
mat_with_na <- matrix(c(1, NA, 3, 4, 5, 6), nrow = 2, byrow = TRUE)
mat_row_all_na <- matrix(c(NA, NA, NA, 1, 2, 3), nrow = 2, byrow = TRUE)
mat_entirely_na <- matrix(NA, nrow = 2, ncol = 3)
mat_nan <- matrix(c(1, NaN, 3, 4, 5, 6), nrow = 2, byrow = TRUE)
mat_inf <- matrix(c(1, Inf, 3, 4, 5, 6), nrow = 2, byrow = TRUE)
mat_inf_cancel <- matrix(c(Inf, -Inf, 0, 1, 2, 3), nrow = 2, byrow = TRUE)
mat_named <- matrix(1:4, nrow = 2, dimnames = list(c("a", "b"), NULL))
df_with_na <- data.frame(x = c(1, NA), y = c(2, 3))

# test -------------------------------------------------------------------------
expect_warning(result <- rowMeans(mat_row_all_na), "missing value")
expect_true(is.nan(result[1]))
