% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precipitation-indices.R
\name{calculate_Rx5day}
\alias{calculate_Rx5day}
\title{Calculate maximum consecutive 5-day precipitation (Rx5day)}
\usage{
calculate_Rx5day(
  df,
  frequency = "daily",
  time_col = NULL,
  prcp_col = NULL,
  precip_col = NULL
)
}
\arguments{
\item{df}{Data frame with precipitation data}

\item{frequency}{Temporal frequency: "daily" or "hourly" (string)}

\item{time_col}{Name of the time column (string). Must be in a format recognizable by lubridate
(e.g., Date for daily data, POSIXct for hourly data). Recommended formats:
- Daily: YYYY-MM-DD (e.g., "2023-01-15")
- Hourly: YYYY-MM-DD HH:MM:SS (e.g., "2023-01-15 14:30:00")}

\item{prcp_col}{Name of precipitation column (daily data) (string)}

\item{precip_col}{Name of precipitation column (hourly data) (string)}
}
\value{
A data.frame with columns: year, Rx5day
}
\description{
Calculates the annual maximum precipitation amount accumulated
over 5 consecutive days, following ETCCDI definition Rx5day.
}
\examples{
# Daily precipitation data
daily_prcp <- data.frame(
  date = seq(as.Date("2000-01-01"), as.Date("2002-12-31"), by = "day"),
  rainfall = pmax(0, rgamma(1096, shape = 0.5, scale = 10))
)

# Calculate maximum 5-day precipitation
calculate_Rx5day(
  df = daily_prcp,
  frequency = "daily",
  time_col = "date",
  prcp_col = "rainfall"
)

# Hourly precipitation data (converted to daily)
hourly_prcp <- data.frame(
  datetime = seq(
    as.POSIXct("2000-01-01 00:00", tz = "UTC"),
    as.POSIXct("2000-01-31 23:00", tz = "UTC"),
    by = "hour"
  ),
  precip = pmax(0, rgamma(31*24, shape = 0.3, scale = 2))
)

calculate_Rx5day(
  df = hourly_prcp,
  frequency = "hourly",
  time_col = "datetime",
  precip_col = "precip"
)
}
