% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precipitation-indices.R
\name{calculate_R1mm}
\alias{calculate_R1mm}
\title{Calculate number of days with precipitation \eqn{\geq} 1mm (R1mm)}
\usage{
calculate_R1mm(
  df,
  frequency = "daily",
  time_col = NULL,
  prcp_col = NULL,
  precip_col = NULL,
  threshold = 1
)
}
\arguments{
\item{df}{Data frame with precipitation data}

\item{frequency}{Temporal frequency: "daily" or "hourly"}

\item{time_col}{Name of the time column (string). Must be in a format recognizable by lubridate
(e.g., Date for daily data, POSIXct for hourly data). Recommended formats:
- Daily: YYYY-MM-DD (e.g., "2023-01-15")
- Hourly: YYYY-MM-DD HH:MM:SS (e.g., "2023-01-15 14:30:00")}

\item{prcp_col}{Name of precipitation column (daily data) (string)}

\item{precip_col}{Name of precipitation column (hourly data) (string)}

\item{threshold}{Precipitation threshold in mm (default: 1)}
}
\value{
A data.frame with columns: year, R1mm
}
\description{
Counts the number of days per year when precipitation \eqn{\geq} 1 mm,
representing wet days.
}
\examples{
# Daily precipitation data
daily_prcp <- data.frame(
  date = seq(as.Date("2000-01-01"), as.Date("2002-12-31"), by = "day"),
  rainfall = pmax(0, rgamma(1096, shape = 0.5, scale = 10))
)

# Calculate number of days with precipitation \eqn{\geq} 1mm (wet days)
calculate_R1mm(
  df = daily_prcp,
  frequency = "daily",
  time_col = "date",
  prcp_col = "rainfall"
)

# With custom threshold (0.5mm instead of 1mm)
calculate_R1mm(
  df = daily_prcp,
  frequency = "daily",
  time_col = "date",
  prcp_col = "rainfall",
  threshold = 0.5
)
}
