% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genotype.R
\name{genotype}
\alias{genotype}
\alias{geno_direct}
\title{Genotype samples from tidy variants}
\usage{
genotype(variants, ploidy = 2, ADt = 10)

geno_direct(variants, ploidy, ADt)
}
\arguments{
\item{variants}{Tidy variants.}

\item{ploidy}{'1', force haploid genotypes; '2', force diploid genotypes;
'poly', all variants are assumed to be real alleles.}

\item{ADt}{Threshold of AD to discriminate hemi/homo-zygotes.}
}
\value{
Tidy genotypes. Dataframe with tidy genotypes.
'sample, 'locus', 'allele', 'allele_no', 'reads', 'nt', 'md5', 'sequence'.
\emph{reads}, supporting allele copies are corrected: 'reads' from tidy variants
are divided between resulting alleles in homozygotes and hemizygotes.
}
\description{
Performs straight genotyping from variants based on ploidy, ADt.
}
\details{
For 'ploidy':
\itemize{
\item '1', force haploid genotypes.
\item '2', force diploid genotypes. If number of alleles is == 1, ADt criterium
is applied to differentiate between "homozygotes" and "hemizygotes".
\item 'poly', all variants are assumed to be real alleles.
No ADt filter is applied.
}
}
\examples{
data("variants")
genotype(variants[1:100,],
    ADt = 10, ploidy = 2
)
}
