% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{table_to_matrix}
\alias{table_to_matrix}
\title{Switch table to matrix}
\usage{
table_to_matrix(
  table,
  row_names = NULL,
  col_names = NULL,
  threshold = 0,
  return_sparse = FALSE
)
}
\arguments{
\item{table}{A table with three columns: \code{row}, \code{col}, and \code{value}.}

\item{row_names}{Character vector of row names to filter by.}

\item{col_names}{Character vector of column names to filter by.}

\item{threshold}{The threshold for filtering values based on absolute values.
Defaults to \code{0}.}

\item{return_sparse}{Whether to return a sparse matrix. Defaults to \code{false}.}
}
\value{
A matrix.
}
\description{
Switch table to matrix
}
\examples{
table <- data.frame(
  row = c("r1", "r2", "r3", "r4", "r5", "r6"),
  col = c("c4", "c5", "c6", "c1", "c2", "c3"),
  value = c(0.6, -0.5, -0.4, 0.3, 0.2, 0.1)
)
matrix <- table_to_matrix(table)
table_new <- matrix_to_table(matrix)
identical(table, table_new)

table_to_matrix(table, threshold = 0.3)

table_to_matrix(
  table,
  row_names = c("r1", "r2"),
  col_names = c("c4", "c5")
)

sparse_matrix <- simulate_sparse_matrix(10, 10)
table_sparse <- matrix_to_table(
  sparse_matrix,
  keep_zero = TRUE
)
sparse_matrix_new <- table_to_matrix(
  table_sparse,
  return_sparse = TRUE
)
identical(sparse_matrix, sparse_matrix_new)
}
