% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verbatim_popup.R
\name{verbatim_popup}
\alias{verbatim_popup}
\alias{verbatim_popup_ui}
\alias{verbatim_popup_srv}
\title{A \code{shiny} module that pops up verbatim text.}
\usage{
verbatim_popup_ui(id, button_label, type = c("button", "link"), ...)

verbatim_popup_srv(
  id,
  verbatim_content,
  title,
  style = FALSE,
  disabled = shiny::reactiveVal(FALSE)
)
}
\arguments{
\item{id}{(\code{character(1)}) the \code{shiny} id}

\item{button_label}{(\code{character(1)}) the text printed on the button}

\item{type}{(\code{character(1)}) specifying whether to use \verb{[shiny::actionButton()]} or \verb{[shiny::actionLink()]}.}

\item{...}{additional arguments to \verb{[shiny::actionButton()]}(or \verb{[shiny::actionLink()]}).}

\item{verbatim_content}{(\code{character}, \code{expression}, \code{condition} or \code{reactive(1)}
holding any of the above) the content to show in the popup modal window}

\item{title}{(\code{character(1)}) the title of the modal window}

\item{style}{(\code{logical(1)}) whether to style the \code{verbatim_content} using \code{styler::style_text}.
If \code{verbatim_content} is a \code{condition} or \code{reactive} holding \code{condition} then this argument is ignored}

\item{disabled}{(\code{reactive(1)}) the \code{shiny} reactive value holding a \code{logical}. The popup button is disabled
when the flag is \code{TRUE} and enabled otherwise.}
}
\value{
the UI function returns a \code{shiny.tag.list} object
}
\description{
This module consists of a button that once clicked pops up a
modal window with verbatim-styled text.
}
\examples{
library(shiny)

ui <- bslib::page_fluid(verbatim_popup_ui("my_id", button_label = "Open popup"))
srv <- function(input, output) {
  verbatim_popup_srv(
    "my_id",
    "if (TRUE) { print('Popups are the best') }",
    title = "My custom title",
    style = TRUE
  )
}
if (interactive()) shinyApp(ui, srv)

}
