% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{plot_qsm3d}
\alias{plot_qsm3d}
\title{Plot QSM Cylinders in 3D}
\usage{
plot_qsm3d(qsm, bg = "white", color = "black", alpha = 0.7)
}
\arguments{
\item{qsm}{A data frame or tibble containing QSM cylinder data with columns:
\code{startX}, \code{startY}, \code{startZ}, \code{endX}, \code{endY}, \code{endZ}, and \code{radius_cyl}.}

\item{bg}{Background color for the 3D plot. Defaults to \code{"white"}.}

\item{color}{Cylinder color. Defaults to \code{"black"}.}

\item{alpha}{Transparency level for cylinders, between 0 (fully transparent) and 1 (fully opaque).
Defaults to \code{0.7}.}
}
\value{
Opens an interactive 3D rgl window with rendered cylinders.
  Returns \code{NULL} invisibly.

A `ggplot` object combining multiple diagnostic panels.
}
\description{
Renders a 3D visualization of tree cylinders (from a Quantitative Structure Model, QSM)
using actual geometric radii. Each cylinder is drawn between its start and end coordinates
with the radius provided in the QSM data.
}
\details{
This function uses \pkg{rgl} to draw 3D cylinders representing each segment
of a tree model. It is intended for visualizing QSM output such as that
produced by \pkg{PyTLidar} or other tree reconstruction algorithms.

For large models, rendering may be slow because each cylinder is drawn as
a separate mesh. Consider downsampling or filtering before plotting.
}
\examples{
# Load QSM output (example path)
qsm_file = system.file('extdata',"tree_0744_qsm.txt", package='tReeTraits')
qsm = load_qsm(qsm_file)
# Plot with real radii
\donttest{
plot_qsm3d(qsm, color = "forestgreen", alpha = 0.6)
}
}
