% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traits_from_point_cloud.R
\name{get_crown_lever_arm}
\alias{get_crown_lever_arm}
\title{Calculate crown leverage from point cloud}
\usage{
get_crown_lever_arm(las, segment_height = 0.25, quantile = c(0.001), angle = 0)
}
\arguments{
\item{las}{`LAS` object from `lidR` package representing
individually segmented tree, with the crown labeled. See `segment_crown()`}

\item{segment_height}{numeric - height of each segment in which to calculate area}

\item{quantile}{numeric - quantile at which width is measured
Values in the interval approaching 0 (e.g., 0.001) are recommended to
trim random noise}

\item{angle}{numeric - angle at which to rotate the point cloud prior

to estimating area. Useful in a loop if quantifying mulitple angles}
}
\value{
A numeric value representing the crown lever arm.
}
\description{
This function calculates the lever arm of canopies. The function
#' is a simple wrapper for `get_area_profile()`. It calculates the crown area
in segments defined by `segement_height`, multiplies the area of each of those
segments by their height, and then returns the sum of all segments. This
is proportaionl to drag calculations on the tree assuming  windspeed is
invariant with height.
}
\examples{
library(lidR)
las = readLAS(system.file("extdata", "tree_0744.laz", package="tReeTraits"))
las = clean_las(las)
las = segment_crown(las)
print(get_crown_lever_arm(las))
}
