% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{ci.rsqr}
\alias{ci.rsqr}
\title{Confidence interval for squared multiple correlation}
\usage{
ci.rsqr(alpha, r2, s, n)
}
\arguments{
\item{alpha}{alpha value for 1-alpha confidence}

\item{r2}{estimated unadjusted squared multiple correlation}

\item{s}{number of predictor variables}

\item{n}{sample size}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item R-squared - estimate of unadjusted R-squared (from input)
\item adj R-squared - bias adjusted R-squared estimate
\item SE - recovered standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes an approximate confidence interval for a population squared
multiple correlation in a linear model with random predictor variables.
This function uses the scaled central F approximation method. An
approximate standard error is recovered from the confidence interval.

For more details, see Section 2.4 of Bonett (2021, Volume 2)
}
\examples{
ci.rsqr(.05, .247, 4, 150)

# Should return:
# R-squared adj R-squared      SE      LL     UL  
#     0.247        0.2262 0.06024  0.1152 0.3514
 

}
\references{
\insertRef{Helland1987}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
