% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Welford.R
\name{Welford}
\alias{Welford}
\alias{update.Welford}
\title{A Welford accumulator for sample mean and variance}
\usage{
Welford(dn, means, vars)

\method{update}{Welford}(object, newdata, ...)
}
\arguments{
\item{dn, means, vars}{initialization of the Welford object: if \code{means}
and \code{vars} are given, they are treated as the running means and
variances, and \code{dn} is their associated sample size, and if not,
\code{dn} is the dimension of the vector (with sample size 0).}

\item{object}{a \code{Welford} object.}

\item{newdata}{either a numeric vector of length \code{d}, a numeric
matrix with \code{d} columns for a group update, or another \code{Welford}
object with the same \code{d}.}

\item{...}{additional arguments to methods.}
}
\value{
an object of type \code{Welford}: a list with four elements:
\enumerate{
\item \code{n}: Running number of observations
\item \code{means}: Running mean for each variable
\item \code{SSDs}: Running sum of squared deviations from the mean for each variable
\item \code{vars}: Running variance of each variable
}
}
\description{
A simple class for keeping track of the running mean and the sum of squared deviations from the mean for a vector.
}
\section{Methods (by generic)}{
\itemize{
\item \code{update(Welford)}: Update a \code{Welford} object with new
data.

}}
\examples{

X <- matrix(rnorm(200), 20, 10)
w0 <- Welford(10)

w <- update(w0, X)
stopifnot(isTRUE(all.equal(w$means, colMeans(X))))
stopifnot(isTRUE(all.equal(w$vars, apply(X,2,var))))

w <- update(w0, X[1:12,])
w <- update(w, X[13:20,])
stopifnot(isTRUE(all.equal(w$means, colMeans(X))))
stopifnot(isTRUE(all.equal(w$vars, apply(X,2,var))))

w <- Welford(12, colMeans(X[1:12,]), apply(X[1:12,], 2, var))
w <- update(w, X[13:20,])
stopifnot(isTRUE(all.equal(w$means, colMeans(X))))
stopifnot(isTRUE(all.equal(w$vars, apply(X,2,var))))

}
