% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hp.R
\name{ssd_hp}
\alias{ssd_hp}
\alias{ssd_hp.fitdists}
\alias{ssd_hp.fitburrlioz}
\title{Hazard Proportion}
\usage{
ssd_hp(x, ...)

\method{ssd_hp}{fitdists}(
  x,
  conc = 1,
  ...,
  average = TRUE,
  ci = FALSE,
  level = 0.95,
  nboot = 1000,
  min_pboot = 0.95,
  multi_est = deprecated(),
  est_method = "multi",
  ci_method = "weighted_samples",
  parametric = TRUE,
  delta = 9.21,
  proportion = FALSE,
  samples = FALSE,
  save_to = NULL,
  control = NULL
)

\method{ssd_hp}{fitburrlioz}(
  x,
  conc = 1,
  ...,
  ci = FALSE,
  level = 0.95,
  nboot = 1000,
  min_pboot = 0.95,
  parametric = FALSE,
  proportion = FALSE,
  samples = FALSE,
  save_to = NULL
)
}
\arguments{
\item{x}{The object.}

\item{...}{Unused.}

\item{conc}{A numeric vector of concentrations to calculate the hazard proportions for.}

\item{average}{A flag specifying whether to provide model averaged values as opposed to a value for each distribution.}

\item{ci}{A flag specifying whether to estimate confidence intervals (by bootstrapping).}

\item{level}{A number between 0 and 1 of the confidence level of the interval.}

\item{nboot}{A count of the number of bootstrap samples to use to estimate the confidence limits. A value of 10,000 is recommended for official guidelines.}

\item{min_pboot}{A number between 0 and 1 of the minimum
proportion of bootstrap samples that must successfully fit (return a likelihood)
to report the confidence intervals.}

\item{multi_est}{A flag specifying whether to estimate directly from
the model-averaged cumulative distribution function (\code{multi_est = TRUE}) or
to take the arithmetic mean of the estimates from the
individual cumulative distribution functions weighted
by the AICc derived weights  (\code{multi_est = FALSE}).}

\item{est_method}{A string specifying whether to estimate directly from
the model-averaged cumulative distribution function (\code{est_method = 'multi'}) or
to take the arithmetic mean of the estimates from the
individual cumulative distribution functions weighted
by the AICc derived weights  (\code{est_method = 'arithmetic'}) or
or to use the geometric mean instead (\code{est_method = 'geometric'}).}

\item{ci_method}{A string specifying which method to use for estimating
the standard error and confidence limits from the bootstrap samples.
The default and recommended value is still \code{ci_method = "weighted_samples"}
which takes bootstrap samples
from each distribution proportional to its AICc based weights and
calculates the confidence limits (and SE) from this single set.
\code{ci_method = "multi_fixed"} and  \code{ci_method = "multi_free"}
generate the bootstrap samples using the model-averaged cumulative distribution function
but differ in whether the model weights are fixed at the values for the original dataset
or re-estimated for each bootstrap sample dataset.
The value \code{ci_method = "MACL"} (was \code{ci_method = "weighted_arithmetic"}), which is only included for
historical reasons, takes the weighted arithmetic mean of the confidence
limits while \code{ci_method = GMACL} which
takes the weighted geometric mean of the confidence limits was added for completeness but is also not recommended.
Finally \code{ci_method = "arithmetic_samples"} and \code{ci_method = "geometric_samples"}
take the weighted arithmetic or geometric mean of the values for
each bootstrap iteration across all the distributions and then
calculate the confidence limits (and SE) from the single set of samples.}

\item{parametric}{A flag specifying whether to perform parametric bootstrapping as opposed to non-parametrically resampling the original data with replacement.}

\item{delta}{A non-negative number specifying the maximum absolute AIC difference cutoff.
Distributions with an absolute AIC difference greater than delta are excluded from the calculations.}

\item{proportion}{A flag specifying whether to return hazard proportions
(\code{proportion = TRUE}) or hazard percentages (\code{proportion = FALSE}).
To not break existing code the default value is \code{FALSE} but
will be switching the default to \code{TRUE} in a future version.
The user is recommended to manually set to \code{TRUE} now to avoid
unexpected changes in future versions.}

\item{samples}{A flag specfying whether to include a numeric vector of the bootstrap samples as a list column in the output.}

\item{save_to}{NULL or a string specifying a directory to save where the bootstrap datasets and parameter estimates (when successfully converged) to.}

\item{control}{A list of control parameters passed to \code{\link[stats:optim]{stats::optim()}}.}
}
\value{
A tibble of corresponding hazard proportions.
}
\description{
Calculates proportion of species affected at specified concentration(s)
with quantile based bootstrap confidence intervals for
individual or model-averaged distributions
using parametric or non-parametric bootstrapping.
For more information see the inverse function \code{\link[=ssd_hc]{ssd_hc()}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{ssd_hp(fitdists)}: Hazard Proportions for fitdists Object

\item \code{ssd_hp(fitburrlioz)}: Hazard Proportions for fitburrlioz Object

}}
\examples{
fits <- ssd_fit_dists(ssddata::ccme_boron)
ssd_hp(fits, conc = 1)

fit <- ssd_fit_burrlioz(ssddata::ccme_boron)
ssd_hp(fit)
}
\seealso{
\code{\link[=ssd_hc]{ssd_hc()}}
}
