% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qts-sample-class.R
\name{autoplot.qts_sample}
\alias{autoplot.qts_sample}
\title{Plot for \code{\link{qts_sample}} objects}
\usage{
\method{autoplot}{qts_sample}(
  object,
  memberships = NULL,
  highlighted = NULL,
  with_animation = FALSE,
  ...
)
}
\arguments{
\item{object}{An object of class \code{\link{qts_sample}}.}

\item{memberships}{A vector coercible as factor specifying a group membership
for each QTS in the sample. Defaults to \code{NULL}, in which case no grouping
structure is displayed.}

\item{highlighted}{A boolean vector specifying whether each QTS in the sample
should be hightlighted. Defaults to \code{NULL}, in which case no QTS is
hightlighted w.r.t. the others.}

\item{with_animation}{A boolean value specifying whether to create a an
animated plot or a static \link[ggplot2:ggplot]{ggplot2::ggplot} object. Defaults to \code{FALSE}
which will create a static plot.}

\item{...}{Further arguments to be passed to methods.}
}
\value{
A \link[ggplot2:ggplot]{ggplot2::ggplot} object.
}
\description{
This function creates a visualization of a sample of QTS and returns the
corresponding \link[ggplot2:ggplot]{ggplot2::ggplot} object which enable further customization of
the plot.
}
\examples{
\dontshow{if (requireNamespace("ggplot2", quietly = TRUE)) withAutoprint(\{ # examplesIf}
ggplot2::autoplot(vespa64$igp)
\dontshow{\}) # examplesIf}
}
