% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_connect.R
\name{db_connect}
\alias{db_connect}
\title{Connect to a SQL Server database}
\usage{
db_connect(
  server,
  database,
  uid = NULL,
  pwd = NULL,
  port = NULL,
  trusted = TRUE,
  driver = "ODBC Driver 17 for SQL Server",
  pool = FALSE,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{server}{SQL Server hostname, IP address, or instance name}

\item{database}{Database name}

\item{uid}{Username (ignore/keep as NULL if trusted = TRUE)}

\item{pwd}{Password (ignore/keep as NULL if trusted = TRUE)}

\item{port}{Optional port number. If NULL, odbc package handles port resolution}

\item{trusted}{(logical) If TRUE (default), uses Windows authentication}

\item{driver}{ODBC driver name (default is "ODBC Driver 17 for SQL Server")}

\item{pool}{(logical) if TRUE, returns a pooled connection}

\item{quiet}{(logical) if TRUE, suppresses messages}

\item{...}{Additional arguments passed to DBI::dbConnect or pool::dbPool}
}
\value{
A DBI connection or a pool object
}
\description{
Connect to a SQL Server database
}
\examples{
\donttest{
# Connect to a SQL Server database
conn <- db_connect(
  server   = "localhost",
  database = "master",
  quiet    = TRUE
)

# Run a simple query
DBI::dbGetQuery(conn, "SELECT name FROM sys.databases")

# Disconnect when finished
db_disconnect(conn)
}

}
