% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{plants_df}
\alias{plants_df}
\title{Plant richness and predictors for American ecoregions}
\format{
A data frame with 227 rows and 22 columns:
\itemize{
\item \code{ecoregion_id}: Ecoregion identifier.
\item \code{x}: Longitude in degrees (WGS84).
\item \code{y}: Latitude in degrees (WGS84).
\item \code{richness_species_vascular}: Number of vascular plant species (response variable).
\item \code{bias_area_km2}: Ecoregion area in square kilometers.
\item \code{bias_species_per_record}: Species count divided by GBIF spatial records (sampling bias metric).
\item \code{climate_aridity_index_average}: Average aridity index.
\item \code{climate_hypervolume}: Climatic envelope volume computed with \href{https://cran.r-project.org/package=hypervolume}{hypervolume}.
\item \code{climate_velocity_lgm_average}: Average climate velocity since the Last Glacial Maximum.
\item \code{neighbors_count}: Number of immediate neighbors (connectivity metric).
\item \code{neighbors_percent_shared_edge}: Percentage of shared edge with neighbors (connectivity metric).
\item \code{human_population_density}: Human population density.
\item \code{topography_elevation_average}: Average elevation.
\item \code{landcover_herbs_percent_average}: Average herb cover from MODIS Vegetation Continuous Fields.
\item \code{fragmentation_cohesion}: Cohesion index computed with \href{https://CRAN.R-project.org/package=landscapemetrics}{landscapemetrics}.
\item \code{fragmentation_division}: Division index computed with \href{https://CRAN.R-project.org/package=landscapemetrics}{landscapemetrics}.
\item \code{neighbors_area}: Total area of immediate neighbors.
\item \code{human_population}: Total human population.
\item \code{human_footprint_average}: Average human footprint index.
\item \code{climate_bio1_average}: Average mean annual temperature.
\item \code{climate_bio15_minimum}: Minimum precipitation seasonality.

}
}
\usage{
data(plants_df)
}
\description{
Vascular plant species richness for American ecoregions as defined in \href{https://ecoregions2017.appspot.com/}{Ecoregions 2017}.
}
\seealso{
Other data: 
\code{\link{plants_distance}},
\code{\link{plants_predictors}},
\code{\link{plants_response}},
\code{\link{plants_rf}},
\code{\link{plants_rf_spatial}},
\code{\link{plants_xy}}
}
\concept{data}
\keyword{datasets}
