% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soc_discover.R
\name{soc_discover}
\alias{soc_discover}
\title{Discover datasets and public data assets using the Socrata Discovery API}
\usage{
soc_discover(
  attribution = NULL,
  categories = NULL,
  domain_category = NULL,
  domains = NULL,
  ids = NULL,
  names = NULL,
  only = "dataset",
  provenance = NULL,
  query = NULL,
  tags = NULL,
  domain_tags = NULL,
  location = "us",
  limit = 10000
)
}
\arguments{
\item{attribution}{string; Filter by the attribution or publisher}

\item{categories}{character vector; Filter by categories.}

\item{domain_category}{string; Filter by domain category (requires a specified domain).}

\item{domains}{character vector; Filter to domains.}

\item{ids}{character vector; Filter by an asset IDs.}

\item{names}{character vector; Filter by asset names.}

\item{only}{character vector; Filter to specific asset types. Must be one or more of: \code{"chart"}, \code{"dataset"}, \code{"filter"}, \code{"link"}, \code{"map"}, \code{"measure"}, \code{"story"}, \code{"system_dataset"}, \code{"visualization"}. Default is \code{"dataset"}.}

\item{provenance}{string; Filter by provenance: \code{"official"} or \code{"community"}.}

\item{query}{character string; Filter using a a token matching one from an asset's name, description, category, tags, column names, column fieldnames, column descriptions or attribution.}

\item{tags}{character vector; Filter by tags associated with the assets.}

\item{domain_tags}{string; Filter by domain tags associated with the assets (requires a specified domain).}

\item{location}{string; Regional API domain: \code{"us"} (default) or \code{"eu"}.}

\item{limit}{whole number; Maximum number of results (cannot exceed 10,000).}
}
\value{
A tibble containing metadata for each discovered asset. Columns include:
\describe{
\item{id}{Asset identifier (four-by-four ID).}
\item{name}{Asset name.}
\item{attribution}{Attribution or publisher of the asset.}
\item{owner_name}{Display name of the asset owner.}
\item{provenance}{Provenance of asset (official or community).}
\item{description}{Textual description of the asset.}
\item{created}{Date asset was created.}
\item{data_last_updated}{Date asset data was last updated}
\item{metadata_last_updated}{Date asset metadata was last updated}
\item{categories}{Category labels assigned to the asset.}
\item{tags}{Tags associated with the asset.}
\item{domain_category}{Category label assigned by the domain.}
\item{domain_tags}{Tags applied by the domain.}
\item{domain_metadata}{Metadata associated with the asset assigned by the domain.}
\item{column_names}{Names of asset columns.}
\item{column_labels}{Labels of asset columns.}
\item{column_datatypes}{Datatypes of asset columns.}
\item{column_descriptions}{Description of asset columns.}
\item{permalink}{Permanent URL where the asset can be accessed.}
\item{link}{Direct asset link.}
\item{license}{License associated with the asset.}
}
}
\description{
Provides access to the Socrata Discovery API, allowing you to search tens of thousands
of government datasets and assets published on the Socrata platform. Governments at
all levels publish data on topics including crime, permits, finance, healthcare,
research, and performance.
}
\examples{
\dontshow{if (interactive() && httr2::is_online()) withAutoprint(\{ # examplesIf}
# Search for crime-related datasets in the Public Safety category
results <- soc_discover(
  query = "crime",
  categories = "Public Safety",
  only = "dataset"
)
\dontshow{\}) # examplesIf}
}
\seealso{
\url{https://dev.socrata.com/docs/other/discovery}
}
