% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotEventData.R
\name{plotEventData}
\alias{plotEventData}
\title{Plot Simulated Event History Data}
\usage{
plotEventData(data, title = "Event Data")
}
\arguments{
\item{data}{A \code{data.frame} or \code{data.table} containing at least the columns \code{ID}, \code{Time}, and \code{Delta}.}

\item{title}{Character string specifying the plot title. Defaults to \code{"Event Data"}.}
}
\value{
A \code{ggplot} object representing the event data visualization.
}
\description{
Visualizes event history data by plotting individual event times colored and shaped by event type.
Each individual's timeline is displayed horizontally with events marked along it.
}
\examples{
data <- simEventData(10)
plotEventData(data)
}
