% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alphaSimDropIn.R
\name{alphaSimDropIn}
\alias{alphaSimDropIn}
\title{Simulation and Estimation in Drop In Setting with Modified Eta Parameter of Drop In Process}
\usage{
alphaSimDropIn(
  N = 10000,
  alpha = 0.5,
  tau = 5,
  a0 = 1,
  eta = rep(0.1, 4),
  nu = rep(1.1, 4),
  adherence = FALSE,
  lower = 10^(-30),
  upper = 200,
  cens = 0,
  gen_A0 = NULL,
  return_data = FALSE,
  years_lost = FALSE,
  beta_L_A = 0,
  beta_L_Z = 1,
  beta_L_D = 0.5,
  beta_L_C = 0,
  beta_A_L = -0.5,
  beta_A_Z = -0.5,
  beta_A_D = -1,
  beta_A_C = 0,
  beta_Z_L = -1,
  beta_Z_A = 0,
  beta_Z_D = -1,
  beta_Z_C = 0,
  beta_L0_L = 1,
  beta_L0_A = 1,
  beta_L0_Z = 0.1,
  beta_L0_D = 1,
  beta_L0_C = 0,
  beta_A0_L = -1,
  beta_A0_A = 0,
  beta_A0_Z = 0,
  beta_A0_D = -0.5,
  beta_A0_C = 0,
  beta_L_A_prime = 0,
  beta_L_Z_prime = 0,
  beta_L_D_prime = 0,
  beta_L_C_prime = 0,
  beta_A_L_prime = 0,
  beta_A_Z_prime = 0,
  beta_A_D_prime = 0,
  beta_A_C_prime = 0,
  beta_Z_L_prime = 0,
  beta_Z_A_prime = 0,
  beta_Z_D_prime = 0,
  beta_Z_C_prime = 0,
  beta_L0_L_prime = 0,
  beta_L0_A_prime = 0,
  beta_L0_Z_prime = 0,
  beta_L0_D_prime = 0,
  beta_L0_C_prime = 0,
  beta_A0_L_prime = 0,
  beta_A0_A_prime = 0,
  beta_A0_Z_prime = 0,
  beta_A0_D_prime = 0,
  beta_A0_C_prime = 0,
  t_prime = NULL
)
}
\arguments{
\item{N}{Integer. Number of individuals to simulate.}

\item{alpha}{Numeric. Multiplicative factor applied to the \eqn{\eta} parameter of the Drop In process under intervention.}

\item{tau}{Numeric. Time point at which event proportions are compared.}

\item{a0}{Binary (0 or 1). Group indicator to subset results.}

\item{eta}{Numeric vector of length 4. Shape parameters for the Weibull hazards (default length 4 for 4 processes).}

\item{nu}{Numeric vector of length 4. Scale parameters for the Weibull hazards.}

\item{adherence}{Logical. Whether to include a treatment adherence process (default FALSE).}

\item{lower}{Numeric. Lower bound for the root-finding algorithm to invert cumulative hazard.}

\item{upper}{Numeric. Upper bound for the root-finding algorithm to invert cumulative hazard.}

\item{cens}{Binary scalar. Indicates whether individuals are at risk of censoring (default \code{1}).}

\item{gen_A0}{Function. Function to generate the baseline treatment covariate A0. Takes N and L0 as inputs. Default is a Bernoulli(0.5) random variable.}

\item{return_data}{Logical. If \code{TRUE} the simulated data is returned.}

\item{years_lost}{Logical. If \code{TRUE}, computes years lost instead of proportions.}

\item{beta_L_A}{Numeric. Effect of process L on process A.}

\item{beta_L_Z}{Numeric. Effect of process L on process Z.}

\item{beta_L_D}{Numeric. Effect of process L on process D.}

\item{beta_L_C}{Numeric. Effect of process L on process C.}

\item{beta_A_L}{Numeric. Effect of process A on process L.}

\item{beta_A_Z}{Numeric. Effect of process A on process Z.}

\item{beta_A_D}{Numeric. Effect of process A on process D.}

\item{beta_A_C}{Numeric. Effect of process A on process C.}

\item{beta_Z_L}{Numeric. Effect of process Z on process L.}

\item{beta_Z_A}{Numeric. Effect of process Z on process A.}

\item{beta_Z_D}{Numeric. Effect of process Z on process D.}

\item{beta_Z_C}{Numeric. Effect of process Z on process C.}

\item{beta_L0_L}{Numeric. Effect of baseline covariate L0 on process L.}

\item{beta_L0_A}{Numeric. Effect of baseline covariate L0 on process A.}

\item{beta_L0_Z}{Numeric. Effect of baseline covariate L0 on process Z.}

\item{beta_L0_D}{Numeric. Effect of baseline covariate L0 on process D.}

\item{beta_L0_C}{Numeric. Effect of baseline covariate L0 on process C.}

\item{beta_A0_L}{Numeric. Effect of baseline covariate A0 on process L.}

\item{beta_A0_A}{Numeric. Effect of baseline covariate A0 on process A.}

\item{beta_A0_Z}{Numeric. Effect of baseline covariate A0 on process Z.}

\item{beta_A0_D}{Numeric. Effect of baseline covariate A0 on process D.}

\item{beta_A0_C}{Numeric. Effect of baseline covariate A0 on process C.}

\item{beta_L_A_prime}{Numeric. Specifies how L additionally affects A after time t_prime.}

\item{beta_L_Z_prime}{Numeric. Specifies how L additionally affects Z after time t_prime.}

\item{beta_L_D_prime}{Numeric. Specifies how L additionally affects D after time t_prime.}

\item{beta_L_C_prime}{Numeric. Specifies how L additionally affects C after time t_prime.}

\item{beta_A_L_prime}{Numeric. Specifies how L additionally affects A after time t_prime.}

\item{beta_A_Z_prime}{Numeric. Specifies how L additionally affects Z after time t_prime.}

\item{beta_A_D_prime}{Numeric. Specifies how L additionally affects D after time t_prime.}

\item{beta_A_C_prime}{Numeric. Specifies how L additionally affects C after time t_prime.}

\item{beta_Z_L_prime}{Numeric. Specifies how L additionally affects A after time t_prime.}

\item{beta_Z_A_prime}{Numeric. Specifies how L additionally affects Z after time t_prime.}

\item{beta_Z_D_prime}{Numeric. Specifies how L additionally affects D after time t_prime.}

\item{beta_Z_C_prime}{Numeric. Specifies how L additionally affects C after time t_prime.}

\item{beta_L0_L_prime}{Numeric. Specifies how L0 additionally affects L after time t_prime.}

\item{beta_L0_A_prime}{Numeric. Specifies how L0 additionally affects A after time t_prime.}

\item{beta_L0_Z_prime}{Numeric. Specifies how L0 additionally affects Z after time t_prime.}

\item{beta_L0_D_prime}{Numeric. Specifies how L0 additionally affects D after time t_prime.}

\item{beta_L0_C_prime}{Numeric. Specifies how L0 additionally affects C after time t_prime.}

\item{beta_A0_L_prime}{Numeric. Specifies how A0 additionally affects L after time t_prime.}

\item{beta_A0_A_prime}{Numeric. Specifies how A0 additionally affects A after time t_prime.}

\item{beta_A0_Z_prime}{Numeric. Specifies how A0 additionally affects Z after time t_prime.}

\item{beta_A0_D_prime}{Numeric. Specifies how A0 additionally affects D after time t_prime.}

\item{beta_A0_C_prime}{Numeric. Specifies how A0 additionally affects C after time t_prime.}

\item{t_prime}{Numeric scalar or NULL. Time point where effects change (optional).}
}
\value{
A list containing:
\describe{
\item{effect_Z}{Proportion of subjects experiencing Drop In by time \eqn{\tau} with and without intervention.}
\item{effect_death}{Proportion of subjects dying by time \eqn{\tau} with and without intervention.}
}
Or the simulated data.
}
\description{
Simulation and Estimation in Drop In Setting with Modified Shape Parameter of Drop In Process
}
\details{
This function simulates event history data from the Drop In scenario. This is a
scenario with the events Censoring (C), Death (D), Drop In Initiation (Z),
Change in Covariate Process (L) and optionally Treatment (A). It simulates
under where the shape parameter \eqn{\eta} of the Drop In process is multiplied by a factor \code{alpha}.
It evaluates the proportion of death and the proportion of Drop In events by time \eqn{\tau} within
the subgroup defined by \code{A0 = a0}.
}
\examples{
alphaSimDropIn()
}
