% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{SimNuN}
\alias{SimNuN}
\title{Simulate Intercept Vectors
in a Discrete-Time Vector Autoregressive Model
from the Multivariate Normal Distribution}
\usage{
SimNuN(n, nu, vcov_nu_l)
}
\arguments{
\item{n}{Positive integer.
Number of replications.}

\item{nu}{Numeric vector.
Intercept (\eqn{\boldsymbol{\nu}}).}

\item{vcov_nu_l}{Numeric matrix.
Cholesky factorization (\code{t(chol(vcov_nu))})
of the sampling variance-covariance matrix of
\eqn{\boldsymbol{\nu}}.}
}
\value{
Returns a list of random intercept vectors.
}
\description{
This function simulates random intercept vectors
in a discrete-time vector autoregressive model
from the multivariate normal distribution.
}
\examples{
n <- 10
nu <- c(0, 0, 0)
vcov_nu_l <- t(chol(0.001 * diag(3)))
SimNuN(n = n, nu = nu, vcov_nu_l = vcov_nu_l)

}
\seealso{
Other Simulation of State Space Models Data Functions: 
\code{\link{LinSDE2SSM}()},
\code{\link{LinSDECovEta}()},
\code{\link{LinSDECovY}()},
\code{\link{LinSDEMeanEta}()},
\code{\link{LinSDEMeanY}()},
\code{\link{ProjectToHurwitz}()},
\code{\link{ProjectToStability}()},
\code{\link{SSMCovEta}()},
\code{\link{SSMCovY}()},
\code{\link{SSMInterceptEta}()},
\code{\link{SSMInterceptY}()},
\code{\link{SSMMeanEta}()},
\code{\link{SSMMeanY}()},
\code{\link{SimAlphaN}()},
\code{\link{SimBetaN}()},
\code{\link{SimBetaN2}()},
\code{\link{SimBetaNCovariate}()},
\code{\link{SimCovDiagN}()},
\code{\link{SimCovN}()},
\code{\link{SimIotaN}()},
\code{\link{SimPhiN}()},
\code{\link{SimPhiN2}()},
\code{\link{SimPhiNCovariate}()},
\code{\link{SimSSMFixed}()},
\code{\link{SimSSMIVary}()},
\code{\link{SimSSMLinGrowth}()},
\code{\link{SimSSMLinGrowthIVary}()},
\code{\link{SimSSMLinSDEFixed}()},
\code{\link{SimSSMLinSDEIVary}()},
\code{\link{SimSSMOUFixed}()},
\code{\link{SimSSMOUIVary}()},
\code{\link{SimSSMVARFixed}()},
\code{\link{SimSSMVARIVary}()},
\code{\link{SpectralRadius}()},
\code{\link{TestPhi}()},
\code{\link{TestPhiHurwitz}()},
\code{\link{TestStability}()},
\code{\link{TestStationarity}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Simulation of State Space Models Data Functions}
\keyword{simStateSpace}
\keyword{ssm}
