% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simStateSpace-ssm-mean-y.R
\name{SSMMeanY}
\alias{SSMMeanY}
\title{Steady-State Mean Vector for the
Observed Variables in the
State Space Model}
\usage{
SSMMeanY(nu, lambda, mean_eta)
}
\arguments{
\item{nu}{Numeric vector.
Vector of intercept values for the measurement model
(\eqn{\boldsymbol{\nu}}).}

\item{lambda}{Numeric matrix.
Factor loading matrix linking the latent variables
to the observed variables
(\eqn{\boldsymbol{\Lambda}}).}

\item{mean_eta}{Numeric vector.
Steady-state mean vector
of the latent variables
\eqn{\mathrm{Mean} \left( \boldsymbol{\eta} \right)}.}
}
\description{
The steady-state mean vector
for the observed variables
in the state space model
\eqn{\mathrm{Mean} \left( \mathbf{y} \right)}
is given by
\deqn{
  \mathrm{Mean} \left( \mathbf{y} \right)
  =
  \boldsymbol{\nu}
  +
  \boldsymbol{\Lambda}
  \mathrm{Mean} \left( \boldsymbol{\eta} \right)
}
where
\eqn{\boldsymbol{\nu}}
is the vector of intercept values
for the measurement model,
\eqn{\boldsymbol{\Lambda}}
is the matrix of factor loadings,
and
\eqn{\mathrm{Mean} \left( \boldsymbol{\eta} \right)}
is the steady-state mean vector
for the latent variables.
}
\examples{
beta <- matrix(
  data = c(
    0.7, 0.5, -0.1,
    0.0, 0.6, 0.4,
    0.0, 0.0, 0.5
  ),
  nrow = 3
)
alpha <- rep(x = 1, times = 3)
lambda <- diag(3)
nu <- rep(x = 1, times = 3)
mean_eta <- SSMMeanEta(
  beta = beta,
  alpha = alpha
)
SSMMeanY(
  nu = nu,
  lambda = lambda,
  mean_eta = mean_eta
)

}
\seealso{
Other Simulation of State Space Models Data Functions: 
\code{\link{LinSDE2SSM}()},
\code{\link{LinSDECovEta}()},
\code{\link{LinSDECovY}()},
\code{\link{LinSDEMeanEta}()},
\code{\link{LinSDEMeanY}()},
\code{\link{ProjectToHurwitz}()},
\code{\link{ProjectToStability}()},
\code{\link{SSMCovEta}()},
\code{\link{SSMCovY}()},
\code{\link{SSMInterceptEta}()},
\code{\link{SSMInterceptY}()},
\code{\link{SSMMeanEta}()},
\code{\link{SimAlphaN}()},
\code{\link{SimBetaN}()},
\code{\link{SimBetaN2}()},
\code{\link{SimBetaNCovariate}()},
\code{\link{SimCovDiagN}()},
\code{\link{SimCovN}()},
\code{\link{SimIotaN}()},
\code{\link{SimNuN}()},
\code{\link{SimPhiN}()},
\code{\link{SimPhiN2}()},
\code{\link{SimPhiNCovariate}()},
\code{\link{SimSSMFixed}()},
\code{\link{SimSSMIVary}()},
\code{\link{SimSSMLinGrowth}()},
\code{\link{SimSSMLinGrowthIVary}()},
\code{\link{SimSSMLinSDEFixed}()},
\code{\link{SimSSMLinSDEIVary}()},
\code{\link{SimSSMOUFixed}()},
\code{\link{SimSSMOUIVary}()},
\code{\link{SimSSMVARFixed}()},
\code{\link{SimSSMVARIVary}()},
\code{\link{SpectralRadius}()},
\code{\link{TestPhi}()},
\code{\link{TestPhiHurwitz}()},
\code{\link{TestStability}()},
\code{\link{TestStationarity}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Simulation of State Space Models Data Functions}
\keyword{simStateSpace}
\keyword{ssm}
