% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{get_input_values}
\alias{get_input_values}
\title{Get Multiple Values from a \pkg{shiny} Input Object}
\usage{
get_input_values(input, x, ...)
}
\arguments{
\item{input}{A \pkg{shiny} \code{input} object, i.e., the \code{input} argument to the
shiny server.}

\item{x}{A character vector of input names, or a data.frame whose column
names are converted to input names via \code{\link[=get_input_ids]{get_input_ids()}}.}

\item{...}{Passed onto methods.}
}
\value{
A named list of input values corresponding to the names in \code{x}.
}
\description{
Retrieves multiple input values from a \pkg{shiny} \code{input} object based on
the names provided in \code{x}.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
library(shiny)
df <- data.frame(
  name = c("Alice", "Bob"),
  age = c(25, 30),
  completed = c(TRUE, FALSE)
)
ui <- fluidPage(
  sidebarLayout(
    sidebarPanel(
      filterInput(df)
    ),
    mainPanel(
      verbatimTextOutput("output_all"),
      verbatimTextOutput("output_subset")
    )
  )
)
server <- function(input, output, session) {
  output$output_all <- renderPrint({
    get_input_values(input, df)
  })
  output$output_subset <- renderPrint({
    get_input_values(input, c("name", "completed"))
  })
}
shinyApp(ui, server)
\dontshow{\}) # examplesIf}
}
