% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{get_input_ids}
\alias{get_input_ids}
\title{Retrieve the Ids of Input Objects}
\usage{
get_input_ids(x, ...)
}
\arguments{
\item{x}{An object for which to retrieve input ids; typically a data.frame.}

\item{...}{Passed onto methods.}
}
\value{
A character vector of input ids.
}
\description{
Returns the (unnamespaced) ids of the inputs for the provided object.
}
\examples{
df <- data.frame(
  name = c("Alice", "Bob"),
  age = c(25, 30),
  completed = c(TRUE, FALSE)
)

get_input_ids(df)
}
