% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{reactlog}
\alias{reactlog}
\alias{reactlogShow}
\alias{reactlogReset}
\alias{reactlogAddMark}
\title{Reactive Log Visualizer}
\usage{
reactlog()

reactlogShow(time = TRUE)

reactlogReset()

reactlogAddMark(session = getDefaultReactiveDomain())
}
\arguments{
\item{time}{A boolean that specifies whether or not to display the
time that each reactive takes to calculate a result.}

\item{session}{The Shiny session to assign the mark to. Defaults to the
current session.}
}
\description{
Provides an interactive browser-based tool for visualizing reactive
dependencies and execution in your application.
}
\details{
To use the reactive log visualizer, start with a fresh R session and
run the command \code{reactlog::reactlog_enable()}; then launch your
application in the usual way (e.g. using \code{\link[=runApp]{runApp()}}). At
any time you can hit Ctrl+F3 (or for Mac users, Command+F3) in your
web browser to launch the reactive log visualization.

The reactive log visualization only includes reactive activity up
until the time the report was loaded. If you want to see more recent
activity, refresh the browser.

Note that Shiny does not distinguish between reactive dependencies
that "belong" to one Shiny user session versus another, so the
visualization will include all reactive activity that has taken place
in the process, not just for a particular application or session.

As an alternative to pressing Ctrl/Command+F3--for example, if you
are using reactives outside of the context of a Shiny
application--you can run the \code{reactlogShow} function, which will
generate the reactive log visualization as a static HTML file and
launch it in your default browser. In this case, refreshing your
browser will not load new activity into the report; you will need to
call \code{reactlogShow()} explicitly.

For security and performance reasons, do not enable
\code{options(shiny.reactlog=TRUE)} (or \code{reactlog::reactlog_enable()}) in
production environments. When the option is enabled, it's possible
for any user of your app to see at least some of the source code of
your reactive expressions and observers. In addition, reactlog
should be considered a memory leak as it will constantly grow and
will never reset until the R session is restarted.
}
\section{Functions}{
\itemize{
\item \code{reactlog()}: Return a list of reactive information.  Can be used in
conjunction with \link[reactlog:reactlog_show]{reactlog::reactlog_show} to later display the reactlog
graph.

\item \code{reactlogShow()}: Display a full reactlog graph for all sessions.

\item \code{reactlogReset()}: Resets the entire reactlog stack.  Useful for debugging
and removing all prior reactive history.

\item \code{reactlogAddMark()}: Adds "mark" entry into the reactlog stack. This is
useful for programmatically adding a marked entry in the reactlog, rather
than using your keyboard's key combination.

For example, we can \emph{mark} the reactlog at the beginning of an
\code{observeEvent}'s calculation:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{observeEvent(input$my_event_trigger, \{
  # Add a mark in the reactlog
  reactlogAddMark()
  # Run your regular event reaction code here...
  ....
\})
}\if{html}{\out{</div>}}

}}
