% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature.selection.R
\name{feature.selection}
\alias{feature.selection}
\title{Select top features by weighted mean SHAP (WMSHAP)}
\usage{
feature.selection(
  shapley,
  method = "lowerCI",
  cutoff = 0,
  top_n_features = NULL,
  features = NULL
)
}
\arguments{
\item{shapley}{shapley object}

\item{method}{Character. Specifies statistic used for thresholding.
Either \code{"mean"} or \code{"lowerCI"} (default) should be specified.
Ignored if `top_n_features` is provided.}

\item{cutoff}{Numeric. Cutoff for thresholding on `method`.
Default is zero, which means that all
features with lower WMSHAP CI above zero will be selected.}

\item{top_n_features}{Integer. If provided, selects the top N features by `mean`,
overriding `method` and `cutoff`.}

\item{features}{Character vector of features to keep. If provided, it is applied
before `top_n_features`/`cutoff` selection (i.e., selection happens within this set).}
}
\value{
A list with:
\describe{
  \item{shapley}{The updated shapley object.}
  \item{features}{Character vector of selected features, ordered by decreasing mean SHAP.}
  \item{mean}{Numeric vector of mean SHAP values aligned with `features`.}
}
}
\description{
Selects a subset of features from a shapley object.
             Features can be selected by: (1) specified `features`,
             (2) `top_n_features`, or (3) WMSHAP cutoff for "mean" or "lowerCI".
}
\author{
E. F. Haghish
}
