% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.sffdr}
\alias{plot.sffdr}
\alias{plot,}
\title{Plotting function for sffdr object}
\usage{
\method{plot}{sffdr}(x, rng = c(0, 5e-08), ...)
}
\arguments{
\item{x}{A sffdr object.}

\item{rng}{Significance region to show. Optional.}

\item{\ldots}{Additional arguments. Currently unused.}
}
\value{
Nothing of interest.
}
\description{
Graphical display of the sffdr object
}
\examples{
# import data
data(bmi)

# Separate main p-values and conditioning p-values
p <- sumstats$bmi
z <- as.matrix(sumstats[, -1])

# Apply pi0_model to create model
fmod <- pi0_model(z)

# Estimate functional pi0
fpi0_out <- fpi0est(p, z = fmod$zt, pi0_model = fmod$fmod)
fpi0 <- fpi0_out$fpi0

# Apply sffdr
sffdr_out <- sffdr(p, fpi0)

# Plot significance results
plot(sffdr_out, rng = c(0, 5e-4))

}
\seealso{
\code{\link{sffdr}}
}
\author{
Andrew J. Bass
}
\keyword{plot}
