% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ki_access_utilities.R
\name{query_llm_for_roles}
\alias{query_llm_for_roles}
\title{#' Query LLM to Classify Variable Roles}
\usage{
query_llm_for_roles(prompt, model = "gpt-4", api_key = NULL)
}
\arguments{
\item{prompt}{A character string prompt for the LLM.}

\item{model}{The OpenAI model to use (e.g., "gpt-4").}

\item{api_key}{Optional. If not provided, defaults to environment variable OPENAI_API_KEY.}
}
\value{
A named list with fields `keyVars`, `pramVars`, `numVars`, `weightVar`, `strataVar`, `hhId`.
Fields are either character vectors (possibly empty) or NULL.
}
\description{
Sends a prompt to the OpenAI API to classify dataset variables into anonymization roles
for use with the sdcMicro package. If the API key is not provided or set via
`Sys.getenv("OPENAI_API_KEY")`, the function will prompt for it interactively.
}
\author{
Matthias Templ
}
\keyword{internal}
