% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting_Statistics.R
\name{Plot_Cells_per_Sample}
\alias{Plot_Cells_per_Sample}
\title{Plot Number of Cells/Nuclei per Sample}
\usage{
Plot_Cells_per_Sample(
  seurat_object,
  sample_col = "orig.ident",
  group.by = NULL,
  colors_use = NULL,
  dot_size = 1,
  plot_title = "Cells/Nuclei per Sample",
  y_axis_label = "Number of Cells",
  x_axis_label = NULL,
  legend_title = NULL,
  x_lab_rotate = TRUE,
  color_seed = 123
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{sample_col}{Specify which column in meta.data specifies sample ID (i.e. orig.ident).}

\item{group.by}{Column in meta.data slot to group results by (i.e. "Treatment").}

\item{colors_use}{List of colors or color palette to use.}

\item{dot_size}{size of the dots plotted if \code{group.by} is not NULL.  Default is 1.}

\item{plot_title}{Plot title.}

\item{y_axis_label}{Label for y axis.}

\item{x_axis_label}{Label for x axis.}

\item{legend_title}{Label for plot legend.}

\item{x_lab_rotate}{logical.  Whether to rotate the axes labels on the x-axis.  Default is FALSE.}

\item{color_seed}{random seed for the "varibow" palette shuffle if \code{colors_use = NULL} and number of
groups plotted is greater than 36.  Default = 123.}
}
\value{
A ggplot object
}
\description{
Plot of total cell or nuclei number per sample grouped by another meta data variable.
}
\examples{
\dontrun{
Plot_Cells_per_Sample(seurat_object = obj, sample_col = "orig.ident", group.by = "Treatment")
}

}
\concept{stats_plotting}
