% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{.matchesLangTemplate}
\alias{.matchesLangTemplate}
\title{Check if a language object matches a template language object}
\usage{
.matchesLangTemplate(x, template)
}
\arguments{
\item{x}{The object to check}

\item{template}{The template object it should match}
}
\value{
TRUE if it matches, FALSE, otherwise
}
\description{
\itemize{
\item{If \code{template == str2lang(".")}, it will match anything.}
\item{If \code{template == str2lang(".name")}, it will match any name.}
\item{If \code{template == str2lang(".call()")}, it will match any call.}
}
}
\examples{
.matchesLangTemplate(str2lang("d/dt(foo)"), str2lang("d/dt(.name)"))
.matchesLangTemplate(str2lang("d/dt(foo)"), str2lang("d/foo(.name)"))
.matchesLangTemplate(str2lang("d/dt(foo)"), str2lang("d/."))
}
\keyword{Internal}
