% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{which_run}
\alias{which_run}
\title{Running which}
\usage{
which_run(
  x,
  k = integer(0),
  lag = integer(1),
  idx = integer(0),
  at = integer(0),
  which = "last",
  na_rm = TRUE,
  na_pad = FALSE
)
}
\arguments{
\item{x}{(\code{vector}, \code{data.frame}, \code{matrix}, \code{xts}, \code{grouped_df})\cr
Input in runner custom function \code{f}.}

\item{k}{(\code{integer} vector or single value)\cr
Denoting size of the running window. If \code{k} is a single value then window
size is constant for all elements, otherwise if \code{length(k) == length(x)}
different window size for each element. One can also specify \code{k} in the same
way as \code{by} argument in \code{\link[base:seq.POSIXt]{base::seq.POSIXt()}}.
See 'Specifying time-intervals' in details section.}

\item{lag}{(\code{integer} vector or single value)\cr
Denoting window lag. If \code{lag} is a single value then window lag is constant
for all elements, otherwise if \code{length(lag) == length(x)} different window
size for each element. Negative value shifts window forward. One can also
specify \code{lag} in the same way as \code{by} argument in
\code{\link[base:seq.POSIXt]{base::seq.POSIXt()}}. See 'Specifying time-intervals' in details
section.}

\item{idx}{(\code{integer}, \code{Date}, \code{POSIXt})\cr
Optional integer vector containing sorted (ascending) index of observation.
By default \code{idx} is index incremented by one. User can provide index with
varying increment and with duplicated values. If specified then \code{k} and
\code{lag} are depending on \code{idx}. Length of \code{idx} have to be equal of length
\code{x}.}

\item{at}{(\code{integer}, \code{Date}, \code{POSIXt}, \code{character} vector)\cr
Vector of any size and any value defining output data points. Values of the
vector defines the indexes which data is computed at. Can be also \code{POSIXt}
sequence increment used in \code{at} argument in \code{\link[base:seq.POSIXt]{base::seq.POSIXt()}}.
See 'Specifying time-intervals' in details section.}

\item{which}{\code{character} value "first" or "last" denoting if the first or last \code{TRUE}
index is returned from the window.}

\item{na_rm}{\code{logical} single value (default \code{na_rm = TRUE}) -
if \code{TRUE} sum is calculating excluding \code{NA}.}

\item{na_pad}{(\code{logical} single value)\cr
Whether incomplete window should return \code{NA} (if \code{na_pad = TRUE})
Incomplete window is when some parts of the window are out of range.}
}
\value{
integer vector of indexes of the same length as \code{x}.
}
\description{
\code{min_run} calculates running which - returns index of element where \code{x == TRUE}.
}
\examples{
set.seed(11)
x1 <- sample(c(1, 2, 3), 15, replace = TRUE)
x2 <- sample(c(NA, 1, 2, 3), 15, replace = TRUE)
k  <- sample(1:4, 15, replace = TRUE)
which_run(x1)
which_run(x2, na_rm = TRUE)
which_run(x2, na_rm = TRUE, k = 4)
which_run(x2, na_rm = FALSE, k = k)
}
