% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/revisions.R
\name{tramoseats_revisions}
\alias{tramoseats_revisions}
\title{Revisions History}
\usage{
tramoseats_revisions(
  ts,
  spec,
  data_ids = NULL,
  ts_ids = NULL,
  cmp_ids = NULL,
  context = NULL
)
}
\arguments{
\item{ts}{The time series used for the estimation.}

\item{spec}{The specification used.}

\item{data_ids}{A \code{list} of \code{list} to specify the statistics to export.
Each sub-list must contain two elements:
\code{start} (first date to compute the history, in the format \code{"YYYY-MM-DD"})
and \code{id} (the name of the statistics, see \code{\link[=tramoseats_dictionary]{tramoseats_dictionary()}}).
See example.}

\item{ts_ids}{A \code{list} of \code{list} to specify the specific date of a component whose history is to be studied.
Each sub-list must contain three elements:
\code{start} (first date to compute the history, in the format \code{"YYYY-MM-DD"}),
\code{period} (the date of the studied)
and \code{id} (the name of the component, see \code{\link[=tramoseats_dictionary]{tramoseats_dictionary()}}).
See example.}

\item{cmp_ids}{A \code{list} of \code{list} to specify the component whose history is to be studied.
Each sub-list must contain three elements:
\code{start} (first date to compute the history, in the format \code{"YYYY-MM-DD"}),
\code{end} (last date to compute the history, in the format \code{"YYYY-MM-DD"})
and \code{id} (the name of the component, see \code{\link[=tramoseats_dictionary]{tramoseats_dictionary()}}).
As many series as periods between \code{start} and \code{end} will be exported.
See example.}

\item{context}{The context of the specification.}
}
\value{
returns a list
}
\description{
Computes revisions history
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
\donttest{
s <- rjd3toolkit::ABS$X0.2.09.10.M
sa_mod <- tramoseats(s)
data_ids <- list(
    # Get the coefficient of the trading-day coefficient from 2005-jan
    list(start = "2005-01-01", id = "regression.td(1)"),
    # Get the ljung-box statistics on residuals from 2010-jan
    list(start = "2010-01-01", id = "residuals.lb")
)
ts_ids <- list(
    # Get the SA component estimates of 2010-jan from 2010-jan
    list(period = "2010-01-01", start = "2010-01-01", id = "sa"),
    # Get the irregular component estimates of 2010-jan from 2015-jan
    list(period = "2010-01-01", start = "2015-01-01", id = "i")
)
cmp_ids <- list(
    # Get the SA component estimates (full time series) 2010-jan to 2020-jan
    list(start = "2010-01-01", end = "2020-01-01", id = "sa"),
    # Get the trend component estimates (full time series)  2010-jan to 2020-jan
    list(start = "2010-01-01", end = "2020-01-01", id = "t")
)
rh <- tramoseats_revisions(s, sa_mod$result_spec, data_ids, ts_ids, cmp_ids)
}
\dontshow{\}) # examplesIf}
}
