% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependency_tree.R
\name{detect_version_conflicts}
\alias{detect_version_conflicts}
\title{Detect Version Conflicts from dependency tree}
\usage{
detect_version_conflicts(pkg_list)
}
\arguments{
\item{pkg_list}{A nested list structure from fetch_all_dependencies function}
}
\value{
A list of strings describing package version conflicts such as "Conflict in package cli: versions found - 3.6.2, 3.6.1"
`NULL` if no conflicts are found.
}
\description{
This function identifies duplicate version packages and reports conflicts.
}
\examples{
pkg_list <- list(
  ggplot2 = list(
    version = "3.5.1",
    cli = list(version = "3.6.2"),
    gtable = list(
      version = "0.3.4",
      cli = list(version = "3.6.1")
    )
  )
)
detect_version_conflicts(pkg_list)

}
