% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parquet_io.R
\name{create_parquet_backend}
\alias{create_parquet_backend}
\title{Create ParquetBackend from Directory}
\usage{
create_parquet_backend(data_dir, cache_size = 10, validate = TRUE)
}
\arguments{
\item{data_dir}{Path to directory containing Parquet files and metadata}

\item{cache_size}{Maximum number of matrices to cache in memory (default: 10)}

\item{validate}{If TRUE, validates directory before creating backend (default: TRUE)}
}
\value{
A ParquetBackend object
}
\description{
Convenience function to create a ParquetBackend from a validated directory.
}
\examples{
\dontrun{
backend <- create_parquet_backend("my_connectomes")
sample <- CSample$new(backend = backend, metric_obj = airm())
}

}
