% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPT2.R
\name{harmonizeCall}
\alias{harmonizeCall}
\title{Harmonize all forms of call}
\usage{
harmonizeCall(callList, .callingEnv, .functionName = NULL)
}
\arguments{
\item{callList}{A named list with elements \code{call}, \code{usesDots} and \code{FUNorig}}

\item{.callingEnv}{The calling environment where \code{Cache} was called from}

\item{.functionName}{A possible function name. If omitted, then it will be deduced
from the \code{callList} and may be inaccurate.}
}
\value{
A named list. We illustrate with the example \code{rnorm(1)}. The named
list will have the original \code{callList} (\code{call} (the original call, without \code{quote}),
\code{FUNorig}, the original value passed by user to \code{FUN}, and \code{usesDots} which
is a logical indicating whether the \code{...} are used), and appended with \code{new_call}
(the harmonized call, with the function and arguments evaluated, e.g.,
\code{(function (n, mean = 0, sd = 1) .Call(C_rnorm, n, mean, sd))(1)}), \code{func_call}, the same harmonized call
with neither function nor arguments not evaluated (e.g., \code{rnorm(1)}), \code{func} which
will be function or method definition
\code{function (n, mean = 0, sd = 1) .Call(C_rnorm, n, mean, sd)},
and \code{.functionName}, which will be the function name as a character string (\code{rnorm})
either directly passed from the user's \code{.functionName} or deduced from the \code{func_call}.
}
\description{
This will convert all known (imagined) calls so that they have the same canonical
format i.e., \code{rnorm(n = 1, mean = 0, sd = 1)}
}
