% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_spec.r
\name{header_image}
\alias{header_image}
\title{Insert an image into the page header}
\usage{
header_image(x, image_path, height, width, align = "left")
}
\arguments{
\item{x}{The report object.}

\item{image_path}{The path of image file. Function accepts JPG images 
for RTF, DOCX, PDF, and HTML output types. Function also accepts 
PNG images for RTF, DOCX, and HTML output types.}

\item{height}{Desired height of the image, in the report units of measure.}

\item{width}{Desired width of the image, in the report units of measure.}

\item{align}{Alignment of the image. Valid values are "left", "right", 
"center", or "centre". The default value is "left".}
}
\value{
The modified report specification.
}
\description{
The \code{header_image} function inserts an image into the page header. The function
can be used to add a logo or other graphical element to the report.
The image will then appear at the top of each page.
}
\details{
The function assumes 
the existence of a page header inserted by the \code{\link{page_header}} function. 
If there is no page header, an error will be generated during the rendering
process in \code{\link{write_report}}. If there is text
in the same cell as the image, the text will be disregarded. You may add text 
to other cells in the header.

The "align" parameter determines which page header cell the image will be inserted.
That is, if you align an image "left", it will be inserted into the left
column of the page header. Options are "left", "right", and "center".  To
insert images in multiple cells, you may use multiple calls to 
\code{image_header}.

The page header cell width will take priority over the image width.  That is,
if you set the image width larger than the cell width, the image width
will be reduced to fit the cell.  To make a wider image, increase the cell
width on the page header.  

Note that page header cells can be removed
entirely by setting the width to zero.  This feature can give you more room
for a wide image. For instance, to create a banner image over the entire report, 
align the image "center" and set the left and right page header column 
widths to zero.

See the \code{\link{page_header}} function for more information on
setting header column widths.  For a demonstration of 
a header image insertion, see \code{vignette("reporter-hfimage")}.
}
\seealso{
Other report: 
\code{\link{add_content}()},
\code{\link{create_report}()},
\code{\link{footer_image}()},
\code{\link{footnotes}()},
\code{\link{options_fixed}()},
\code{\link{page_by}()},
\code{\link{page_footer}()},
\code{\link{page_header}()},
\code{\link{print.report_spec}()},
\code{\link{set_margins}()},
\code{\link{title_header}()},
\code{\link{titles}()},
\code{\link{write_report}()}
}
\concept{report}
