% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_dhis2-helpers.R
\name{get_api_version}
\alias{get_api_version}
\title{Get DHIS2 API version}
\usage{
get_api_version(login)
}
\arguments{
\item{login}{A httr2_response object returned by the \code{dhis2_login()} function}
}
\value{
A numeric with minor version of the API
}
\description{
Get DHIS2 API version
}
\examples{
\dontrun{
  # login to the DHIS2 instance
  dhis2_login <- login(
    type = "dhis2",
    from = "https://smc.moh.gm/dhis",
    user_name = "test",
    password = "Gambia@123"
  )

  # get the API version
  api_version <- get_api_version(login = dhis2_login)
}
}
