% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRadar.R
\name{plotRadar}
\alias{plotRadar}
\title{plot radar products on a pretty map}
\usage{
plotRadar(
  x,
  layer = NULL,
  main = names(x),
  land = "gray80",
  sea = "cadetblue1",
  de = "grey80",
  eu = "black",
  col = berryFunctions::seqPal(),
  xlim = NULL,
  ylim = NULL,
  zlim = NULL,
  axes = TRUE,
  las = 1,
  mar = c(2.5, 3.5, 2.5, 5),
  keeppar = TRUE,
  project = TRUE,
  proj = "radolan",
  extent = "radolan",
  adjust05 = FALSE,
  targetproj = "ll",
  quiet = rdwdquiet(),
  ...
)
}
\arguments{
\item{x}{terra raster oject, e.g. 'dat' element of object returned by \code{\link[=readDWD]{readDWD()}}.}

\item{layer}{Optional: selected layer(s) to be plotted. DEFAULT: NULL}

\item{main}{Graph title(s). Use "" to suppress.
DEFAULT: names(x)}

\item{land}{Color of land areas in the map. DEFAULT: "gray80"}

\item{sea}{Color of sea areas in the map. DEFAULT: "cadetblue1"}

\item{de}{Color of Deutschland Bundesland borders. DEFAULT: "grey80"}

\item{eu}{Color of Europe country borders . DEFAULT: "black"}

\item{col}{Color palette for the data itself.
DEFAULT: \code{\link[berryFunctions:seqPal]{berryFunctions::seqPal()}}}

\item{xlim}{xlim. DEFAULT: NULL, i.e. taken from x extent (after reprojection if \code{project=TRUE})}

\item{ylim}{ylim. DEFAULT: NULL, i.e. taken from y extent (after reprojection if \code{project=TRUE})}

\item{zlim}{zlim. 3 Options: two-number vector,
\code{zlim="ind"} for individual zlim per layer,
or NULL for \code{range} of selected layer(s).
DEFAULT: NULL}

\item{axes}{Draw axes? DEFAULT: TRUE}

\item{las}{LabelAxisStyle for axes. DEFAULT: 1 (all upright)}

\item{mar}{Vector with plot margins. DEFAULT: c(2.5, 3.5, 2.5, 5)}

\item{keeppar}{Logical: keep the margins set with par, so later points etc are
added in the right location?
DEFAULT: TRUE, opposite to \code{sf::plot} with reset=TRUE, see
\url{https://github.com/cran/sf/blob/master/R/plot.R}}

\item{project}{Project the data before plotting? Not needed if
\code{\link[=projectRasterDWD]{projectRasterDWD()}} has already been called. DEFAULT: TRUE}

\item{proj}{current projection, see \code{\link[=projectRasterDWD]{projectRasterDWD()}},
used only if \code{project=TRUE}. DEFAULT: "radolan"}

\item{extent}{current extent, see \code{\link[=projectRasterDWD]{projectRasterDWD()}},
used only if \code{project=TRUE}. DEFAULT: "radolan"}

\item{adjust05}{Logical: Adjust extent by 0.5m to match edges? DEFAULT: FALSE}

\item{targetproj}{target projection, see \code{\link[=projectRasterDWD]{projectRasterDWD()}},
used only if \code{project=TRUE}. DEFAULT: "ll"}

\item{quiet}{suppress progress messages? DEFAULT: FALSE through \code{\link[=rdwdquiet]{rdwdquiet()}}}

\item{\dots}{Further arguments passed to \code{\link[terra:plot]{terra::plot()}}}
}
\value{
terra object, (re)projected (if \code{project=TRUE}).
If \code{length(layer)==1}, only that selected layer is returned.
}
\description{
Convenience function to plot radar products on a pretty map.
Creates a separate plot for each layer, a selection is possible.
}
\examples{
# See https://brry.github.io/rdwd/raster-data.html
\dontrun{ ## Excluded from CRAN checks: requires internet connection
link <- "seasonal/air_temperature_mean/16_DJF/grids_germany_seasonal_air_temp_mean_188216.asc.gz"
rad <- dataDWD(link, base=gridbase, joinbf=TRUE)
radp <- plotRadar(rad, proj="seasonal", extent=NULL, main="plotRadar ex")
plotRadar(radp, ylim=c(52,54), project=FALSE)

# plotRadar equivalent, map only country borders:
radpm <- projectRasterDWD(rad[[1]], proj="seasonal", extent=NULL)
terra::plot(radpm)
addBorders()

# several layers
url <- "daily/Project_TRY/pressure/PRED_199606_daymean.nc.gz"  #  5 MB
nc <- dataDWD(url, base=gridbase, joinbf=TRUE)

ncp3 <- plotRadar(nc, main=paste(terra::longnames(nc), terra::time(nc)), layer=1:3,
                  col=terrain.colors(100), proj="nc", extent="nc")
plotRadar(ncp3, layer=3:4, project=FALSE) # still has all layers
plotRadar(ncp3, layer=4:5, project=FALSE, zlim="ind") # individual zlims per layer
plotRadar(ncp3, layer=1, project=FALSE, zlim=c(1016,1020))

ncp1 <- plotRadar(nc, layer=1, proj="nc", extent="nc") # much faster projection
# no longer has layers 2-4:
berryFunctions::is.error(plotRadar(ncp1, layer=1:4, project=FALSE), TRUE, TRUE)
}

}
\seealso{
\code{\link[=projectRasterDWD]{projectRasterDWD()}}, \code{\link[=addBorders]{addBorders()}}, \code{\link[=readDWD]{readDWD()}},
\href{https://brry.github.io/rdwd/raster-data.html}{website raster chapter}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Feb 2020, June 2023
}
\keyword{aplot}
\keyword{spatial}
